/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.gimple.GimpleOp;

public class PrimitiveBinOpGenerator
implements SimpleExpr {
    private int opCode;
    private final SimpleExpr x;
    private final SimpleExpr y;

    public PrimitiveBinOpGenerator(GimpleOp op, SimpleExpr x, SimpleExpr y) {
        this.opCode = PrimitiveBinOpGenerator.opCodeFor(op);
        this.x = x;
        this.y = y;
        this.checkTypes();
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.x.getType();
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        this.x.load(mv);
        this.y.load(mv);
        mv.visitInsn(this.getType().getOpcode(this.opCode));
    }

    private static int opCodeFor(GimpleOp op) {
        switch (op) {
            case MULT_EXPR: {
                return 104;
            }
            case PLUS_EXPR: {
                return 96;
            }
            case MINUS_EXPR: {
                return 100;
            }
            case RDIV_EXPR: 
            case TRUNC_DIV_EXPR: 
            case EXACT_DIV_EXPR: {
                return 108;
            }
            case TRUNC_MOD_EXPR: {
                return 112;
            }
            case BIT_AND_EXPR: {
                return 126;
            }
            case BIT_IOR_EXPR: {
                return 128;
            }
            case BIT_XOR_EXPR: {
                return 130;
            }
        }
        return 0;
    }

    private void checkTypes() {
        Type ty;
        Type tx = this.x.getType();
        if (!tx.equals((Object)(ty = this.y.getType()))) {
            throw new IllegalStateException(String.format("Incompatible types for %s: %s != %s", Printer.OPCODES[this.opCode], tx, ty));
        }
    }

    public String toString() {
        return "(" + this.x + " " + Printer.OPCODES[this.opCode] + " " + this.y + ")";
    }
}

