/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.gimple.GimpleOp;

public class MinMaxValue
implements SimpleExpr {
    private GimpleOp op;
    private SimpleExpr x;
    private SimpleExpr y;

    public MinMaxValue(GimpleOp op, SimpleExpr x, SimpleExpr y) {
        this.op = op;
        this.x = x;
        this.y = y;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.x.getType();
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        String methodName;
        this.x.load(mv);
        this.y.load(mv);
        Type type = this.x.getType();
        if (!type.equals((Object)this.y.getType())) {
            throw new UnsupportedOperationException(String.format("Types must be the same: %s != %s", this.x.getType(), this.y.getType()));
        }
        switch (this.op) {
            case MIN_EXPR: {
                methodName = "min";
                break;
            }
            case MAX_EXPR: {
                methodName = "max";
                break;
            }
            default: {
                throw new IllegalArgumentException("op: " + (Object)((Object)this.op));
            }
        }
        mv.invokestatic(Math.class, methodName, Type.getMethodDescriptor((Type)type, (Type[])new Type[]{type, type}));
    }
}

