/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import javax.annotation.Nonnull;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;

public class LogicalOr
implements SimpleExpr {
    private SimpleExpr x;
    private SimpleExpr y;

    public LogicalOr(SimpleExpr x, SimpleExpr y) {
        this.x = x;
        this.y = y;
    }

    @Override
    @Nonnull
    public Type getType() {
        return Type.BOOLEAN_TYPE;
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        Label trueLabel = new Label();
        Label exitLabel = new Label();
        this.x.load(mv);
        this.jumpIfTrue(mv, trueLabel);
        this.y.load(mv);
        this.jumpIfTrue(mv, trueLabel);
        mv.iconst(0);
        mv.goTo(exitLabel);
        mv.mark(trueLabel);
        mv.iconst(1);
        mv.mark(exitLabel);
    }

    private void jumpIfTrue(MethodGenerator mv, Label trueLabel) {
        mv.visitJumpInsn(154, trueLabel);
    }
}

