/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import javax.annotation.Nonnull;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;

public class LogicalAnd
implements SimpleExpr {
    private SimpleExpr x;
    private SimpleExpr y;

    public LogicalAnd(SimpleExpr x, SimpleExpr y) {
        this.x = x;
        this.y = y;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.x.getType();
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        Label falseLabel = new Label();
        Label exitLabel = new Label();
        this.x.load(mv);
        this.jumpIfFalse(mv, falseLabel);
        this.y.load(mv);
        this.jumpIfFalse(mv, falseLabel);
        mv.iconst(1);
        mv.goTo(exitLabel);
        mv.mark(falseLabel);
        mv.iconst(0);
        mv.mark(exitLabel);
    }

    private void jumpIfFalse(MethodGenerator mv, Label trueLabel) {
        mv.visitJumpInsn(153, trueLabel);
    }
}

