/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.gimple.type.GimpleBooleanType;
import org.renjin.gcc.gimple.type.GimpleIntegerType;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;
import org.renjin.gcc.gimple.type.GimpleRealType;

public class CastGenerator
implements SimpleExpr {
    private SimpleExpr valueGenerator;
    private GimplePrimitiveType sourceType;
    private GimplePrimitiveType destinationType;

    public CastGenerator(SimpleExpr valueGenerator, GimplePrimitiveType sourceType, GimplePrimitiveType destinationType) {
        this.valueGenerator = valueGenerator;
        this.sourceType = sourceType;
        this.destinationType = destinationType;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.destinationType.jvmType();
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        this.valueGenerator.load(mv);
        if (!this.sourceType.equals(this.destinationType)) {
            this.cast(mv, this.sourceType, this.destinationType);
        }
    }

    private void cast(MethodGenerator mv, GimplePrimitiveType sourceType, GimplePrimitiveType destinationType) {
        Method castMethod;
        String methodName = "cast" + this.castSignature(sourceType) + "To" + this.castSignature(destinationType);
        try {
            castMethod = this.getClass().getMethod(methodName, MethodGenerator.class);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unsupported cast: " + methodName);
        }
        try {
            castMethod.invoke(null, new Object[]{mv});
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerException("Exception invoking " + methodName, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InternalCompilerException("Exception invoking " + methodName, e.getCause());
        }
    }

    private String castSignature(GimplePrimitiveType type) {
        if (type instanceof GimpleIntegerType) {
            GimpleIntegerType intType = (GimpleIntegerType)type;
            int precision = intType.getPrecision();
            if (precision == 0) {
                throw new AssertionError((Object)"precision == 0");
            }
            if (intType.isUnsigned()) {
                return "UnsignedInt" + precision;
            }
            return "Int" + precision;
        }
        if (type instanceof GimpleRealType) {
            return "Real" + ((GimpleRealType)type).getPrecision();
        }
        if (type instanceof GimpleBooleanType) {
            return "Bool";
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static void castBoolToInt8(MethodGenerator mv) {
    }

    public static void castBoolToInt16(MethodGenerator mv) {
    }

    public static void castBoolToInt32(MethodGenerator mv) {
    }

    public static void castBoolToInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castInt8ToBool(MethodGenerator mv) {
    }

    public static void castInt8ToUnsignedInt8(MethodGenerator mv) {
    }

    public static void castInt8ToInt16(MethodGenerator mv) {
    }

    public static void castInt8ToUnsignedInt16(MethodGenerator mv) {
        mv.visitLdcInsn(65535);
        mv.visitInsn(126);
    }

    public static void castInt8ToInt32(MethodGenerator mv) {
    }

    public static void castInt8ToUnsignedInt32(MethodGenerator mv) {
        mv.visitLdcInsn(-1);
        mv.visitInsn(126);
    }

    public static void castInt8ToInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castInt8ToUnsignedInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castInt8ToReal32(MethodGenerator mv) {
        mv.visitInsn(134);
    }

    public static void castInt8ToReal64(MethodGenerator mv) {
        mv.visitInsn(135);
    }

    public static void castUnsignedInt8ToBool(MethodGenerator mv) {
    }

    public static void castUnsignedInt8ToInt8(MethodGenerator mv) {
    }

    public static void castUnsignedInt8ToInt(MethodGenerator mv) {
        mv.visitIntInsn(16, 255);
        mv.visitInsn(126);
    }

    public static void castUnsignedInt8ToInt16(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
    }

    public static void castUnsignedInt8ToUnsignedInt16(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
    }

    public static void castUnsignedInt8ToInt32(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
    }

    public static void castUnsignedInt8ToUnsignedInt32(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
    }

    public static void castUnsignedInt8ToInt64(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
        mv.visitInsn(133);
    }

    public static void castUnsignedInt8ToUnsignedInt64(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
        mv.visitInsn(133);
    }

    public static void castUnsignedInt8ToReal32(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
        mv.visitInsn(134);
    }

    public static void castUnsignedInt8ToReal64(MethodGenerator mv) {
        CastGenerator.castUnsignedInt8ToInt(mv);
        mv.visitInsn(135);
    }

    public static void castInt16ToBool(MethodGenerator mv) {
    }

    public static void castInt16ToInt8(MethodGenerator mv) {
        mv.visitInsn(145);
    }

    public static void castInt16ToUnsignedInt8(MethodGenerator mv) {
        mv.visitInsn(145);
    }

    public static void castInt16ToUnsignedInt16(MethodGenerator mv) {
    }

    public static void castInt16ToInt32(MethodGenerator mv) {
    }

    public static void castInt16ToUnsignedInt32(MethodGenerator mv) {
    }

    public static void castInt16ToInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castInt16ToUnsignedInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castInt16ToReal32(MethodGenerator mv) {
        mv.visitInsn(134);
    }

    public static void castInt16ToReal64(MethodGenerator mv) {
        mv.visitInsn(135);
    }

    public static void castUnsignedInt16ToBool(MethodGenerator mv) {
    }

    public static void castUnsignedInt16ToInt8(MethodGenerator mv) {
        mv.visitInsn(145);
    }

    public static void castUnsignedInt16ToUnsignedInt8(MethodGenerator mv) {
        mv.visitInsn(145);
    }

    public static void castUnsignedInt16ToInt16(MethodGenerator mv) {
        mv.visitInsn(147);
    }

    public static void castUnsignedInt16ToInt32(MethodGenerator mv) {
    }

    public static void castUnsignedInt16ToUnsignedInt32(MethodGenerator mv) {
    }

    public static void castUnsignedInt16ToInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castUnsignedInt16ToUnsignedInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castUnsignedInt16ToReal32(MethodGenerator mv) {
        mv.visitInsn(134);
    }

    public static void castUnsignedInt16ToReal64(MethodGenerator mv) {
        mv.visitInsn(135);
    }

    public static void castInt32ToBool(MethodGenerator mv) {
    }

    public static void castInt32ToInt8(MethodGenerator mv) {
        mv.visitInsn(145);
    }

    public static void castInt32ToUnsignedInt8(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castInt32ToInt16(MethodGenerator mv) {
        mv.visitInsn(147);
    }

    public static void castInt32ToUnsignedInt16(MethodGenerator mv) {
        mv.visitInsn(146);
    }

    public static void castInt32ToInt32(MethodGenerator mv) {
    }

    public static void castInt32ToUnsignedInt32(MethodGenerator mv) {
    }

    public static void castInt32ToInt64(MethodGenerator mv) {
        mv.visitInsn(133);
    }

    public static void castInt32ToUnsignedInt64(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castInt32ToReal32(MethodGenerator mv) {
        mv.visitInsn(134);
    }

    public static void castInt32ToReal64(MethodGenerator mv) {
        mv.visitInsn(135);
    }

    public static void castUnsignedInt32ToBool(MethodGenerator mv) {
    }

    public static void castUnsignedInt32ToInt8(MethodGenerator mv) {
        mv.visitInsn(145);
    }

    public static void castUnsignedInt32ToUnsignedInt8(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt32ToInt16(MethodGenerator mv) {
        mv.visitInsn(147);
    }

    public static void castUnsignedInt32ToUnsignedInt16(MethodGenerator mv) {
        mv.visitInsn(146);
    }

    public static void castUnsignedInt32ToInt32(MethodGenerator mv) {
    }

    public static void castUnsignedInt32ToInt64(MethodGenerator mv) {
        mv.visitInsn(133);
        mv.visitLdcInsn(0xFFFFFFFFL);
        mv.visitInsn(127);
    }

    public static void castUnsignedInt32ToUnsignedInt64(MethodGenerator mv) {
        CastGenerator.castUnsignedInt32ToInt64(mv);
    }

    public static void castUnsignedInt32ToReal32(MethodGenerator mv) {
        CastGenerator.castUnsignedInt32ToInt64(mv);
        mv.visitInsn(138);
    }

    public static void castUnsignedInt32ToReal64(MethodGenerator mv) {
        CastGenerator.castUnsignedInt32ToInt64(mv);
        mv.visitInsn(138);
    }

    public static void castInt64ToBool(MethodGenerator mv) {
        mv.visitInsn(136);
    }

    public static void castInt64ToInt8(MethodGenerator mv) {
        mv.visitInsn(136);
        mv.visitInsn(145);
    }

    public static void castInt64ToUnsignedInt8(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castInt64ToInt16(MethodGenerator mv) {
        mv.visitInsn(136);
        mv.visitInsn(147);
    }

    public static void castInt64ToUnsignedInt16(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castInt64ToInt32(MethodGenerator mv) {
        mv.visitInsn(136);
    }

    public static void castInt64ToUnsignedInt32(MethodGenerator mv) {
        mv.visitInsn(136);
    }

    public static void castInt64ToUnsignedInt64(MethodGenerator mv) {
    }

    public static void castInt64ToReal32(MethodGenerator mv) {
        mv.visitInsn(137);
    }

    public static void castInt64ToReal64(MethodGenerator mv) {
        mv.visitInsn(138);
    }

    public static void castUnsignedInt64ToBool(MethodGenerator mv) {
        mv.visitInsn(136);
    }

    public static void castUnsignedInt64ToInt8(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToUnsignedInt8(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToInt16(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToUnsignedInt16(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToInt32(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToUnsignedInt32(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToInt64(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToReal32(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castUnsignedInt64ToReal64(MethodGenerator mv) {
        throw new UnsupportedOperationException();
    }

    public static void castReal32ToBool(MethodGenerator mv) {
        mv.visitInsn(139);
    }

    public static void castReal32ToInt8(MethodGenerator mv) {
        mv.visitInsn(139);
        mv.visitInsn(145);
    }

    public static void castReal32ToUnsignedInt8(MethodGenerator mv) {
        mv.visitInsn(139);
        mv.visitInsn(145);
    }

    public static void castReal32ToInt16(MethodGenerator mv) {
        mv.visitInsn(139);
        mv.visitInsn(147);
    }

    public static void castReal32ToUnsignedInt16(MethodGenerator mv) {
        mv.visitInsn(139);
        mv.visitInsn(146);
    }

    public static void castReal32ToInt32(MethodGenerator mv) {
        mv.visitInsn(139);
    }

    public static void castReal32ToUnsignedInt32(MethodGenerator mv) {
        mv.visitInsn(140);
        mv.visitInsn(136);
    }

    public static void castReal32ToInt64(MethodGenerator mv) {
        mv.visitInsn(140);
    }

    public static void castReal32ToUnsignedInt64(MethodGenerator mv) {
        mv.visitInsn(140);
    }

    public static void castReal32ToReal64(MethodGenerator mv) {
        mv.visitInsn(141);
    }

    public static void castReal64ToBool(MethodGenerator mv) {
        mv.visitInsn(142);
    }

    public static void castReal64ToInt8(MethodGenerator mv) {
        mv.visitInsn(142);
        mv.visitInsn(145);
    }

    public static void castReal64ToUnsignedInt8(MethodGenerator mv) {
        mv.visitInsn(142);
        mv.visitInsn(145);
    }

    public static void castReal64ToInt16(MethodGenerator mv) {
        mv.visitInsn(142);
        mv.visitInsn(147);
    }

    public static void castReal64ToUnsignedInt16(MethodGenerator mv) {
        mv.visitInsn(142);
        mv.visitInsn(146);
    }

    public static void castReal64ToInt32(MethodGenerator mv) {
        mv.visitInsn(143);
        mv.visitInsn(136);
    }

    public static void castReal64ToUnsignedInt32(MethodGenerator mv) {
        mv.visitInsn(143);
        mv.visitInsn(136);
    }

    public static void castReal64ToInt64(MethodGenerator mv) {
        mv.visitInsn(143);
    }

    public static void castReal64ToUnsignedInt64(MethodGenerator mv) {
        mv.visitInsn(143);
    }

    public static void castReal64ToReal32(MethodGenerator mv) {
        mv.visitInsn(144);
    }
}

