/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive.op;

import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.type.GimpleIntegerType;
import org.renjin.gcc.gimple.type.GimpleType;

public class BitwiseShift
implements SimpleExpr {
    private final GimpleOp op;
    private GimpleIntegerType type;
    private final SimpleExpr x;
    private final SimpleExpr y;

    public BitwiseShift(GimpleOp op, GimpleType type, SimpleExpr x, SimpleExpr y) {
        this.op = op;
        this.type = (GimpleIntegerType)type;
        this.x = x;
        this.y = y;
        if (!this.checkTypes()) {
            throw new UnsupportedOperationException("Shift operations require types (int, int) or (long, int), found: " + this.x.getType() + ", " + this.y.getType());
        }
    }

    private boolean checkTypes() {
        Type tx = this.x.getType();
        Type ty = this.y.getType();
        return (tx.equals((Object)Type.INT_TYPE) || tx.equals((Object)Type.LONG_TYPE)) && ty.equals((Object)tx);
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.x.getType();
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        this.x.load(mv);
        this.y.load(mv);
        Type type = this.x.getType();
        switch (this.op) {
            case LSHIFT_EXPR: {
                mv.shl(type);
                break;
            }
            case RSHIFT_EXPR: {
                if (this.type.isUnsigned()) {
                    mv.ushr(type);
                    break;
                }
                mv.shr(type);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Op: " + (Object)((Object)this.op));
            }
        }
    }
}

