/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive;

import com.google.bc.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleAddressableExpr;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;

public class PrimitiveValueFunction
implements ValueFunction {
    private Type type;
    private int byteSize;

    public PrimitiveValueFunction(GimplePrimitiveType type) {
        this.type = type.jvmType();
        this.byteSize = type.sizeOf();
    }

    public PrimitiveValueFunction(Type type) {
        this.type = type;
        switch (type.getSort()) {
            case 1: 
            case 3: {
                this.byteSize = 1;
                break;
            }
            case 2: 
            case 4: {
                this.byteSize = 2;
                break;
            }
            case 5: 
            case 6: {
                this.byteSize = 4;
                break;
            }
            case 7: 
            case 8: {
                this.byteSize = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("type: " + type);
            }
        }
    }

    @Override
    public Type getValueType() {
        return this.type;
    }

    @Override
    public int getElementLength() {
        return 1;
    }

    @Override
    public int getElementSize() {
        return this.byteSize;
    }

    @Override
    public Expr dereference(SimpleExpr array, SimpleExpr offset) {
        FatPtrExpr address = new FatPtrExpr(array, offset);
        SimpleExpr value = Expressions.elementAt(array, offset);
        return new SimpleAddressableExpr(value, address);
    }

    @Override
    public List<SimpleExpr> toArrayValues(Expr expr) {
        return Collections.singletonList((SimpleExpr)expr);
    }

    @Override
    public Optional<SimpleExpr> getValueConstructor() {
        return Optional.absent();
    }
}

