/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.condition.ConditionGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.gimple.GimpleOp;

public class PrimitiveCmpGenerator
implements ConditionGenerator {
    private GimpleOp op;
    private SimpleExpr x;
    private SimpleExpr y;

    public PrimitiveCmpGenerator(GimpleOp op, SimpleExpr x, SimpleExpr y) {
        this.op = op;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitJump(MethodGenerator mv, Label trueLabel, Label falseLabel) {
        Type ty;
        Type tx = this.x.getType();
        if (!tx.equals((Object)(ty = this.y.getType()))) {
            throw new UnsupportedOperationException("Type mismatch: " + tx + " != " + ty);
        }
        this.x.load(mv);
        this.y.load(mv);
        if (tx.equals((Object)Type.DOUBLE_TYPE) || ty.equals((Object)Type.FLOAT_TYPE)) {
            this.emitRealJump(mv, trueLabel);
        } else {
            mv.visitJumpInsn(this.integerComparison(), trueLabel);
        }
        mv.visitJumpInsn(167, falseLabel);
    }

    private int integerComparison() {
        switch (this.op) {
            case LT_EXPR: {
                return 161;
            }
            case LE_EXPR: {
                return 164;
            }
            case EQ_EXPR: {
                return 159;
            }
            case NE_EXPR: {
                return 160;
            }
            case GT_EXPR: {
                return 163;
            }
            case GE_EXPR: {
                return 162;
            }
        }
        throw new UnsupportedOperationException("op: " + (Object)((Object)this.op));
    }

    private void emitRealJump(MethodGenerator mv, Label trueLabel) {
        switch (this.op) {
            case LT_EXPR: 
            case LE_EXPR: {
                mv.visitInsn(this.isDouble() ? 152 : 150);
                break;
            }
            default: {
                mv.visitInsn(this.isDouble() ? 151 : 149);
            }
        }
        switch (this.op) {
            case LT_EXPR: {
                mv.visitJumpInsn(155, trueLabel);
                break;
            }
            case LE_EXPR: {
                mv.visitJumpInsn(158, trueLabel);
                break;
            }
            case EQ_EXPR: {
                mv.visitJumpInsn(153, trueLabel);
                break;
            }
            case NE_EXPR: {
                mv.visitJumpInsn(154, trueLabel);
                break;
            }
            case GT_EXPR: {
                mv.visitJumpInsn(157, trueLabel);
                break;
            }
            case GE_EXPR: {
                mv.visitJumpInsn(156, trueLabel);
            }
        }
    }

    private boolean isDouble() {
        return this.x.getType().equals((Object)Type.DOUBLE_TYPE);
    }
}

