/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.primitive;

import com.google.bc.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.gimple.expr.GimplePrimitiveConstant;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;

public class ConstantValue
implements SimpleExpr {
    private Number value;
    private Type type;

    public ConstantValue(GimplePrimitiveConstant constant) {
        this.value = constant.getValue();
        this.type = ((GimplePrimitiveType)constant.getType()).jvmType();
    }

    public ConstantValue(Type type, Number value) {
        this.type = type;
        this.value = value;
    }

    public Number getValue() {
        return this.value;
    }

    public int getIntValue() {
        Preconditions.checkState((boolean)this.type.equals((Object)Type.INT_TYPE));
        return this.value.intValue();
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public void load(@Nonnull MethodGenerator mv) {
        switch (this.type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.iconst(this.value.intValue());
                break;
            }
            case 7: {
                mv.lconst(this.value.longValue());
                break;
            }
            case 6: {
                mv.fconst(this.value.floatValue());
                break;
            }
            case 8: {
                mv.dconst(this.value.doubleValue());
                break;
            }
            default: {
                throw new IllegalStateException("type: " + this.type);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantValue that = (ConstantValue)o;
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.type.equals((Object)that.type);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

