/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.complex;

import com.google.bc.common.base.Optional;
import com.google.bc.common.base.Preconditions;
import com.google.bc.common.collect.Lists;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.type.complex.ComplexValue;

public class ComplexValueFunction
implements ValueFunction {
    private final Type valueType;

    public ComplexValueFunction(Type valueType) {
        Preconditions.checkArgument((valueType.equals((Object)Type.DOUBLE_TYPE) || valueType.equals((Object)Type.FLOAT_TYPE) ? 1 : 0) != 0);
        this.valueType = valueType;
    }

    @Override
    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public int getElementLength() {
        return 2;
    }

    @Override
    public int getElementSize() {
        switch (this.valueType.getSort()) {
            case 8: {
                return 16;
            }
            case 6: {
                return 8;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Expr dereference(SimpleExpr array, SimpleExpr offset) {
        FatPtrExpr address = new FatPtrExpr(array, offset);
        SimpleExpr realOffset = offset;
        SimpleExpr imaginaryOffset = Expressions.sum(realOffset, Expressions.constantInt(1));
        SimpleExpr real = Expressions.elementAt(array, realOffset);
        SimpleExpr imaginary = Expressions.elementAt(array, imaginaryOffset);
        return new ComplexValue(address, real, imaginary);
    }

    @Override
    public List<SimpleExpr> toArrayValues(Expr expr) {
        ComplexValue value = (ComplexValue)expr;
        return Lists.newArrayList((Object[])new SimpleExpr[]{value.getRealValue(), value.getImaginaryValue()});
    }

    @Override
    public Optional<SimpleExpr> getValueConstructor() {
        return Optional.absent();
    }
}

