/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.complex;

import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Addressable;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.type.primitive.op.NegativeValue;

public class ComplexValue
implements Expr,
LValue<ComplexValue>,
Addressable {
    private FatPtrExpr address;
    private SimpleExpr realValue;
    private SimpleExpr imaginaryValue;
    private Type componentType;

    public ComplexValue(FatPtrExpr address, SimpleExpr realValue, SimpleExpr imaginaryValue) {
        this.address = address;
        this.realValue = realValue;
        this.imaginaryValue = imaginaryValue;
        if (!realValue.getType().equals((Object)imaginaryValue.getType())) {
            throw new IllegalArgumentException(String.format("Part types do not match: %s != %s", realValue.getType(), imaginaryValue.getType()));
        }
        this.componentType = realValue.getType();
    }

    public ComplexValue(SimpleExpr realValue, SimpleExpr imaginaryValue) {
        this(null, realValue, imaginaryValue);
    }

    public ComplexValue(SimpleExpr realValue) {
        this.realValue = realValue;
        this.imaginaryValue = Expressions.zero(realValue.getType());
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public SimpleExpr getRealValue() {
        return this.realValue;
    }

    public SimpleExpr getImaginaryValue() {
        return this.imaginaryValue;
    }

    @Override
    public void store(MethodGenerator mv, ComplexValue complexValue) {
        ((SimpleLValue)this.realValue).store(mv, complexValue.getRealValue());
        ((SimpleLValue)this.imaginaryValue).store(mv, complexValue.getImaginaryValue());
    }

    public ComplexValue conjugate() {
        return new ComplexValue(this.address, this.realValue, new NegativeValue(this.imaginaryValue));
    }

    @Override
    public FatPtrExpr addressOf() {
        if (this.address == null) {
            throw new UnsupportedOperationException("not addressable");
        }
        return this.address;
    }
}

