/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.complex;

import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.complex.ComplexValue;
import org.renjin.gcc.codegen.var.LocalVarAllocator;
import org.renjin.gcc.gimple.type.GimpleComplexType;

public class ComplexReturnStrategy
implements ReturnStrategy {
    private GimpleComplexType type;

    public ComplexReturnStrategy(GimpleComplexType type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type.getJvmPartArrayType();
    }

    @Override
    public SimpleExpr marshall(Expr expr) {
        ComplexValue complexValue = (ComplexValue)expr;
        return Expressions.newArray(complexValue.getRealValue(), complexValue.getImaginaryValue());
    }

    @Override
    public Expr unmarshall(MethodGenerator mv, SimpleExpr returnValue) {
        LocalVarAllocator.LocalVar array = mv.getLocalVarAllocator().reserve("retval", returnValue.getType());
        array.store(mv, returnValue);
        SimpleExpr realValue = Expressions.elementAt((SimpleExpr)array, 0);
        SimpleExpr imaginaryValue = Expressions.elementAt((SimpleExpr)array, 1);
        return new ComplexValue(realValue, imaginaryValue);
    }

    @Override
    public SimpleExpr getDefaultReturnValue() {
        SimpleExpr zero = Expressions.zero(this.type.getJvmPartType());
        return Expressions.newArray(zero, zero);
    }
}

