/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type.complex;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.condition.ConditionGenerator;
import org.renjin.gcc.codegen.type.complex.ComplexValue;
import org.renjin.gcc.gimple.GimpleOp;

public class ComplexCmpGenerator
implements ConditionGenerator {
    private GimpleOp op;
    private ComplexValue x;
    private ComplexValue y;
    private Type type;

    public ComplexCmpGenerator(GimpleOp op, ComplexValue x, ComplexValue y) {
        this.op = op;
        this.x = x;
        this.y = y;
        this.type = x.getComponentType();
    }

    @Override
    public void emitJump(MethodGenerator mv, Label trueLabel, Label falseLabel) {
        switch (this.op) {
            case EQ_EXPR: {
                this.emitJumpIfEqual(mv, trueLabel, falseLabel);
                break;
            }
            case NE_EXPR: {
                this.emitJumpIfEqual(mv, falseLabel, trueLabel);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported comparison " + (Object)((Object)this.op) + " between complex values");
            }
        }
    }

    private void emitJumpIfEqual(MethodGenerator mv, Label equalLabel, Label notEqualLabel) {
        this.x.getRealValue().load(mv);
        this.y.getRealValue().load(mv);
        mv.cmpg(this.type);
        mv.ifne(notEqualLabel);
        this.x.getImaginaryValue().load(mv);
        this.y.getImaginaryValue().load(mv);
        mv.cmpg(this.type);
        mv.ifne(notEqualLabel);
        mv.goTo(equalLabel);
    }
}

