/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.type;

import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.WrapperType;
import org.renjin.gcc.codegen.array.ArrayTypeStrategy;
import org.renjin.gcc.codegen.fatptr.FatPtrReturnStrategy;
import org.renjin.gcc.codegen.fatptr.FatPtrValueFunction;
import org.renjin.gcc.codegen.fatptr.WrappedFatPtrParamStrategy;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.FieldStrategy;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.PointerTypeStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.SimpleParamStrategy;
import org.renjin.gcc.codegen.type.SimpleReturnStrategy;
import org.renjin.gcc.codegen.type.TypeStrategy;
import org.renjin.gcc.codegen.type.complex.ComplexTypeStrategy;
import org.renjin.gcc.codegen.type.fun.FunTypeStrategy;
import org.renjin.gcc.codegen.type.primitive.PrimitiveTypeStrategy;
import org.renjin.gcc.codegen.type.primitive.PrimitiveValueFunction;
import org.renjin.gcc.codegen.type.primitive.StringParamStrategy;
import org.renjin.gcc.codegen.type.record.RecordClassTypeStrategy;
import org.renjin.gcc.codegen.type.record.RecordTypeStrategy;
import org.renjin.gcc.codegen.type.voidt.VoidPtrParamStrategy;
import org.renjin.gcc.codegen.type.voidt.VoidReturnStrategy;
import org.renjin.gcc.codegen.type.voidt.VoidTypeStrategy;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.type.GimpleArrayType;
import org.renjin.gcc.gimple.type.GimpleComplexType;
import org.renjin.gcc.gimple.type.GimpleField;
import org.renjin.gcc.gimple.type.GimpleFunctionType;
import org.renjin.gcc.gimple.type.GimpleIndirectType;
import org.renjin.gcc.gimple.type.GimpleIntegerType;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;
import org.renjin.gcc.gimple.type.GimpleRecordType;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;
import org.renjin.gcc.gimple.type.GimpleType;
import org.renjin.gcc.gimple.type.GimpleVoidType;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.ObjectPtr;

public class TypeOracle {
    private final Map<String, RecordTypeStrategy> recordTypes = Maps.newHashMap();
    private final Map<String, GimpleRecordType> classTypes = Maps.newHashMap();

    public void addRecordType(GimpleRecordTypeDef type, RecordTypeStrategy strategy) {
        this.recordTypes.put(type.getId(), strategy);
        if (strategy instanceof RecordClassTypeStrategy) {
            this.classTypes.put(((RecordClassTypeStrategy)strategy).getJvmType().getInternalName(), strategy.getRecordType());
        }
    }

    public Collection<RecordTypeStrategy> getRecordTypes() {
        return this.recordTypes.values();
    }

    public PointerTypeStrategy forPointerType(GimpleType type) {
        if (!(type instanceof GimpleIndirectType)) {
            throw new IllegalArgumentException("not a pointer type: " + type);
        }
        return this.forType((GimpleType)type.getBaseType()).pointerTo();
    }

    public ArrayTypeStrategy forArrayType(GimpleType type) {
        if (!(type instanceof GimpleArrayType)) {
            throw new IllegalArgumentException("not an array type: " + type);
        }
        return (ArrayTypeStrategy)this.forType(type);
    }

    public TypeStrategy forType(GimpleType type) {
        if (type instanceof GimplePrimitiveType) {
            return new PrimitiveTypeStrategy((GimplePrimitiveType)type);
        }
        if (type instanceof GimpleComplexType) {
            return new ComplexTypeStrategy((GimpleComplexType)type);
        }
        if (type instanceof GimpleFunctionType) {
            return new FunTypeStrategy((GimpleFunctionType)type);
        }
        if (type instanceof GimpleVoidType) {
            return new VoidTypeStrategy();
        }
        if (type instanceof GimpleRecordType) {
            GimpleRecordType recordType = (GimpleRecordType)type;
            return this.forRecordType(recordType);
        }
        if (type instanceof GimpleIndirectType) {
            return this.forType((GimpleType)type.getBaseType()).pointerTo();
        }
        if (type instanceof GimpleArrayType) {
            GimpleArrayType arrayType = (GimpleArrayType)type;
            return this.forType(arrayType.getComponentType()).arrayOf(arrayType);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private RecordTypeStrategy forRecordType(GimpleRecordType recordType) {
        RecordTypeStrategy recordTypeStrategy = this.recordTypes.get(recordType.getId());
        if (recordTypeStrategy == null) {
            throw new InternalCompilerException(String.format("No record type for GimpleRecordType[name: %s, id: %s]", recordType.getName(), recordType.getId()));
        }
        return recordTypeStrategy;
    }

    public ParamStrategy forParameter(GimpleType parameterType) {
        return this.forType(parameterType).getParamStrategy();
    }

    public FieldStrategy forField(org.objectweb.asm.Type className, GimpleField field) {
        TypeStrategy type = this.forType(field.getType());
        if (field.isAddressed()) {
            return type.addressableFieldGenerator(className, field.getName());
        }
        return type.fieldGenerator(className, field.getName());
    }

    public ReturnStrategy returnStrategyFor(GimpleType returnType) {
        return this.forType(returnType).getReturnStrategy();
    }

    public ReturnStrategy forReturnValue(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return new VoidReturnStrategy();
        }
        if (returnType.isPrimitive()) {
            return new SimpleReturnStrategy(org.objectweb.asm.Type.getType(returnType));
        }
        if (WrapperType.is(returnType)) {
            WrapperType wrapperType = Wrappers.valueOf(returnType);
            if (wrapperType.equals(WrapperType.OBJECT_PTR)) {
                Type genericReturnType = method.getGenericReturnType();
                Class baseType = this.objectPtrBaseType(genericReturnType);
                if (baseType.equals(ObjectPtr.class)) {
                    throw new UnsupportedOperationException(genericReturnType.toString());
                }
                if (WrapperType.is(baseType)) {
                    org.objectweb.asm.Type valueType = Wrappers.valueType(baseType);
                    return new FatPtrReturnStrategy(new FatPtrValueFunction(new PrimitiveValueFunction(valueType)));
                }
                throw new UnsupportedOperationException("baseType: " + baseType);
            }
            org.objectweb.asm.Type valueType = Wrappers.valueType(org.objectweb.asm.Type.getType(returnType));
            return new FatPtrReturnStrategy(new PrimitiveValueFunction(valueType));
        }
        if (this.classTypes.containsKey(org.objectweb.asm.Type.getInternalName(returnType))) {
            GimpleRecordType recordType = this.classTypes.get(org.objectweb.asm.Type.getInternalName(returnType));
            return this.recordTypes.get(recordType.getId()).pointerTo().getReturnStrategy();
        }
        if (returnType.equals(Object.class)) {
            return new SimpleReturnStrategy(org.objectweb.asm.Type.getType(Object.class));
        }
        throw new UnsupportedOperationException(String.format("Unsupported return type %s in method %s.%s", returnType.getName(), method.getDeclaringClass().getName(), method.getName()));
    }

    public List<ParamStrategy> forParameterTypesOf(Method method) {
        ArrayList<ParamStrategy> strategies = new ArrayList<ParamStrategy>();
        int numParams = method.isVarArgs() ? method.getParameterTypes().length - 1 : method.getParameterTypes().length;
        int index = 0;
        while (index < numParams) {
            Class<?> paramClass = method.getParameterTypes()[index];
            if (paramClass.equals(ObjectPtr.class)) {
                strategies.add(this.forObjectPtrParam(method.getGenericParameterTypes()[index]));
                ++index;
                continue;
            }
            if (WrapperType.is(paramClass)) {
                org.objectweb.asm.Type valueType = Wrappers.valueType(paramClass);
                strategies.add(new WrappedFatPtrParamStrategy(new PrimitiveValueFunction(valueType)));
                ++index;
                continue;
            }
            if (paramClass.isPrimitive()) {
                strategies.add(new SimpleParamStrategy(org.objectweb.asm.Type.getType(paramClass)));
                ++index;
                continue;
            }
            if (paramClass.equals(String.class)) {
                strategies.add(new StringParamStrategy());
                ++index;
                continue;
            }
            if (this.classTypes.containsKey(org.objectweb.asm.Type.getInternalName(paramClass))) {
                GimpleRecordType mappedType = this.classTypes.get(org.objectweb.asm.Type.getInternalName(paramClass));
                strategies.add(((RecordClassTypeStrategy)this.forRecordType(mappedType)).pointerToUnit().getParamStrategy());
                ++index;
                continue;
            }
            if (paramClass.equals(Object.class)) {
                strategies.add(new VoidPtrParamStrategy());
                ++index;
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unsupported parameter %d of type %s", index, paramClass.getName()));
        }
        return strategies;
    }

    private Class objectPtrBaseType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new InternalCompilerException(ObjectPtr.class.getSimpleName() + " parameters must be parameterized");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private ParamStrategy forObjectPtrParam(Type type) {
        Class baseType = this.objectPtrBaseType(type);
        if (baseType.equals(BytePtr.class)) {
            return this.forType(new GimpleIntegerType(8)).pointerTo().pointerTo().getParamStrategy();
        }
        String baseTypeInternalName = org.objectweb.asm.Type.getInternalName((Class)baseType);
        if (this.classTypes.containsKey(baseTypeInternalName)) {
            GimpleRecordType mappedType = this.classTypes.get(baseTypeInternalName);
            return this.recordTypes.get(mappedType.getId()).pointerTo().getParamStrategy();
        }
        throw new UnsupportedOperationException("TODO: baseType = " + baseType);
    }

    public Map<GimpleParameter, ParamStrategy> forParameters(List<GimpleParameter> parameters) {
        HashMap<GimpleParameter, ParamStrategy> map = new HashMap<GimpleParameter, ParamStrategy>();
        for (GimpleParameter parameter : parameters) {
            map.put(parameter, this.forParameter(parameter.getType()));
        }
        return map;
    }

    public static String getMethodDescriptor(ReturnStrategy returnStrategy, List<ParamStrategy> paramStrategies) {
        ArrayList types = Lists.newArrayList();
        for (ParamStrategy paramStrategy : paramStrategies) {
            types.addAll(paramStrategy.getParameterTypes());
        }
        org.objectweb.asm.Type[] typesArray = types.toArray(new org.objectweb.asm.Type[types.size()]);
        return org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)returnStrategy.getType(), (org.objectweb.asm.Type[])typesArray);
    }
}

