/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.WrapperType;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.runtime.BooleanPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.FloatPtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.ShortPtr;

public class Wrappers {
    public static Type valueType(Class<?> wrapperClass) {
        return Wrappers.valueType(Type.getType(wrapperClass));
    }

    public static Type valueType(Type wrapperType) {
        if (wrapperType.equals((Object)Type.getType(BooleanPtr.class))) {
            return Type.BOOLEAN_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(BytePtr.class))) {
            return Type.BYTE_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(ShortPtr.class))) {
            return Type.SHORT_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(CharPtr.class))) {
            return Type.CHAR_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(IntPtr.class))) {
            return Type.INT_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(LongPtr.class))) {
            return Type.LONG_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(FloatPtr.class))) {
            return Type.FLOAT_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(DoublePtr.class))) {
            return Type.DOUBLE_TYPE;
        }
        if (wrapperType.equals((Object)Type.getType(ObjectPtr.class))) {
            return Type.getType(Object.class);
        }
        throw new IllegalArgumentException("not a wrapper type: " + wrapperType);
    }

    public static Type fieldArrayType(Type wrapperType) {
        if (wrapperType.equals((Object)Type.getType(ObjectPtr.class))) {
            return Type.getType((String)"[Ljava/lang/Object;");
        }
        Type valueType = Wrappers.valueType(wrapperType);
        Type arrayType = Type.getType((String)("[" + valueType.getDescriptor()));
        return arrayType;
    }

    public static Type valueArrayType(Type valueType) {
        return Type.getType((String)("[" + valueType.getDescriptor()));
    }

    public static SimpleExpr arrayField(SimpleExpr wrapperInstance) {
        return Expressions.field(wrapperInstance, Wrappers.fieldArrayType(wrapperInstance.getType()), "array");
    }

    public static SimpleExpr arrayField(SimpleExpr instance, Type valueType) {
        SimpleExpr array = Wrappers.arrayField(instance);
        Type arrayType = Wrappers.arrayType(valueType);
        if (!array.getType().equals((Object)arrayType)) {
            array = Expressions.cast(array, arrayType);
        }
        return array;
    }

    private static Type arrayType(Type valueType) {
        return Type.getType((String)("[" + valueType.getDescriptor()));
    }

    public static SimpleExpr offsetField(SimpleExpr wrapperInstance) {
        return Expressions.field(wrapperInstance, Type.INT_TYPE, "offset");
    }

    public static Type wrapperType(Type valueType) {
        switch (valueType.getSort()) {
            case 1: {
                return Type.getType(BooleanPtr.class);
            }
            case 4: {
                return Type.getType(ShortPtr.class);
            }
            case 3: {
                return Type.getType(BytePtr.class);
            }
            case 2: {
                return Type.getType(CharPtr.class);
            }
            case 5: {
                return Type.getType(IntPtr.class);
            }
            case 7: {
                return Type.getType(LongPtr.class);
            }
            case 6: {
                return Type.getType(FloatPtr.class);
            }
            case 8: {
                return Type.getType(DoublePtr.class);
            }
            case 10: {
                return Type.getType(ObjectPtr.class);
            }
        }
        throw new UnsupportedOperationException("No wrapper for type: " + valueType);
    }

    public static WrapperType valueOf(Class<?> wrapperClass) {
        return WrapperType.valueOf(Type.getType(wrapperClass));
    }
}

