/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import com.google.bc.common.collect.Lists;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.var.VarAllocator;
import org.renjin.gcc.gimple.GimpleParameter;

public class WrappedFatPtrParamStrategy
implements ParamStrategy {
    private ValueFunction valueFunction;

    public WrappedFatPtrParamStrategy(ValueFunction valueFunction) {
        this.valueFunction = valueFunction;
    }

    @Override
    public List<Type> getParameterTypes() {
        return Lists.newArrayList((Object[])new Type[]{Wrappers.wrapperType(this.valueFunction.getValueType())});
    }

    @Override
    public Expr emitInitialization(MethodGenerator mv, GimpleParameter parameter, List<SimpleLValue> paramVars, VarAllocator localVars) {
        SimpleLValue array = localVars.reserveArrayRef(parameter.getName() + "$array", this.valueFunction.getValueType());
        SimpleLValue offset = localVars.reserveInt(parameter.getName() + "$offset");
        SimpleExpr wrapper = paramVars.get(0);
        array.store(mv, Wrappers.arrayField(wrapper, this.valueFunction.getValueType()));
        offset.store(mv, Wrappers.offsetField(wrapper));
        return new FatPtrExpr(array, offset);
    }

    @Override
    public void loadParameter(MethodGenerator mv, Expr argument) {
        if (argument instanceof SimpleExpr) {
            SimpleExpr wrappedPtr = Expressions.cast((SimpleExpr)argument, Wrappers.wrapperType(this.valueFunction.getValueType()));
            wrappedPtr.load(mv);
        } else if (argument instanceof FatPtrExpr) {
            FatPtrExpr fatPtrExpr = (FatPtrExpr)argument;
            fatPtrExpr.wrap().load(mv);
        } else {
            throw new IllegalArgumentException("argument: " + argument);
        }
    }
}

