/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import com.google.bc.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;

public class FatPtrValueFunction
implements ValueFunction {
    private final ValueFunction baseValueFunction;
    private final Type arrayType;

    public FatPtrValueFunction(ValueFunction baseValueFunction) {
        this.baseValueFunction = baseValueFunction;
        this.arrayType = Wrappers.valueArrayType(baseValueFunction.getValueType());
    }

    @Override
    public Type getValueType() {
        return Wrappers.wrapperType(this.baseValueFunction.getValueType());
    }

    @Override
    public int getElementLength() {
        return 1;
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    @Override
    public Expr dereference(SimpleExpr array, SimpleExpr offset) {
        FatPtrExpr address = new FatPtrExpr(array, offset);
        SimpleExpr wrapperInstance = Expressions.elementAt(array, offset);
        SimpleExpr unwrappedArray = Wrappers.arrayField(wrapperInstance, this.baseValueFunction.getValueType());
        SimpleExpr unwrappedOffset = Wrappers.offsetField(wrapperInstance);
        return new FatPtrExpr(address, unwrappedArray, unwrappedOffset);
    }

    @Override
    public List<SimpleExpr> toArrayValues(Expr expr) {
        FatPtrExpr fatPtrExpr = (FatPtrExpr)expr;
        return Collections.singletonList(fatPtrExpr.wrap());
    }

    @Override
    public Optional<SimpleExpr> getValueConstructor() {
        return Optional.of((Object)FatPtrExpr.nullPtr(this.baseValueFunction).wrap());
    }
}

