/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.array.ArrayTypeStrategy;
import org.renjin.gcc.codegen.condition.ConditionGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.AddressableField;
import org.renjin.gcc.codegen.fatptr.FatPtrConditionGenerator;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrFieldStrategy;
import org.renjin.gcc.codegen.fatptr.FatPtrMalloc;
import org.renjin.gcc.codegen.fatptr.FatPtrMemCmp;
import org.renjin.gcc.codegen.fatptr.FatPtrParamStrategy;
import org.renjin.gcc.codegen.fatptr.FatPtrRealloc;
import org.renjin.gcc.codegen.fatptr.FatPtrReturnStrategy;
import org.renjin.gcc.codegen.fatptr.FatPtrValueFunction;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.WrappedFatPtrParamStrategy;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.FieldStrategy;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.PointerTypeStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.var.VarAllocator;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleConstructor;
import org.renjin.gcc.gimple.type.GimpleArrayType;

public class FatPtrStrategy
implements PointerTypeStrategy<FatPtrExpr> {
    private ValueFunction valueFunction;
    private boolean parametersWrapped = true;
    private Type arrayType;

    public FatPtrStrategy(ValueFunction valueFunction) {
        this.valueFunction = valueFunction;
        this.arrayType = Type.getType((String)("[" + valueFunction.getValueType().getDescriptor()));
    }

    public boolean isParametersWrapped() {
        return this.parametersWrapped;
    }

    public FatPtrStrategy setParametersWrapped(boolean parametersWrapped) {
        this.parametersWrapped = parametersWrapped;
        return this;
    }

    @Override
    public FatPtrExpr variable(GimpleVarDecl decl, VarAllocator allocator) {
        if (decl.isAddressable()) {
            Type wrapperType = Wrappers.wrapperType(this.valueFunction.getValueType());
            Type wrapperArrayType = Wrappers.valueArrayType(wrapperType);
            FatPtrExpr nullPtr = FatPtrExpr.nullPtr(this.valueFunction);
            SimpleLValue unitArray = allocator.reserve(decl.getName(), wrapperArrayType, Expressions.newArray(nullPtr.wrap(), new SimpleExpr[0]));
            FatPtrExpr address = new FatPtrExpr(unitArray);
            SimpleExpr instance = Expressions.elementAt((SimpleExpr)unitArray, 0);
            SimpleExpr unwrappedArray = Wrappers.arrayField(instance, this.valueFunction.getValueType());
            SimpleExpr unwrappedOffset = Wrappers.offsetField(instance);
            return new FatPtrExpr(address, unwrappedArray, unwrappedOffset);
        }
        SimpleLValue array = allocator.reserve(decl.getName(), this.arrayType);
        SimpleLValue offset = allocator.reserveInt(decl.getName() + "$offset");
        return new FatPtrExpr(array, offset);
    }

    @Override
    public FatPtrExpr constructorExpr(ExprFactory exprFactory, GimpleConstructor value) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public FieldStrategy fieldGenerator(Type className, String fieldName) {
        return new FatPtrFieldStrategy(this.valueFunction, fieldName);
    }

    @Override
    public FieldStrategy addressableFieldGenerator(Type className, String fieldName) {
        return new AddressableField(className, fieldName, new FatPtrValueFunction(this.valueFunction));
    }

    @Override
    public ParamStrategy getParamStrategy() {
        if (this.isParametersWrapped()) {
            return new WrappedFatPtrParamStrategy(this.valueFunction);
        }
        return new FatPtrParamStrategy(this.valueFunction);
    }

    @Override
    public ReturnStrategy getReturnStrategy() {
        return new FatPtrReturnStrategy(this.valueFunction);
    }

    @Override
    public FatPtrExpr malloc(MethodGenerator mv, SimpleExpr length) {
        return FatPtrMalloc.alloc(mv, this.valueFunction, length);
    }

    @Override
    public FatPtrExpr realloc(FatPtrExpr pointer, SimpleExpr length) {
        FatPtrRealloc array = new FatPtrRealloc(pointer, length);
        SimpleExpr offset = Expressions.zero();
        return new FatPtrExpr(array, offset);
    }

    @Override
    public Expr valueOf(FatPtrExpr pointerExpr) {
        return this.valueFunction.dereference(pointerExpr.getArray(), pointerExpr.getOffset());
    }

    @Override
    public FatPtrStrategy pointerTo() {
        return new FatPtrStrategy(new FatPtrValueFunction(this.valueFunction));
    }

    @Override
    public ArrayTypeStrategy arrayOf(GimpleArrayType arrayType) {
        return new ArrayTypeStrategy(arrayType, new FatPtrValueFunction(this.valueFunction));
    }

    @Override
    public FatPtrExpr pointerPlus(FatPtrExpr pointer, SimpleExpr offsetInBytes) {
        int bytesPerArrayElement = this.valueFunction.getElementSize() / this.valueFunction.getElementLength();
        SimpleExpr offsetInArrayElements = Expressions.divide(offsetInBytes, bytesPerArrayElement);
        SimpleExpr newOffset = Expressions.sum(pointer.getOffset(), offsetInArrayElements);
        return new FatPtrExpr(pointer.getArray(), newOffset);
    }

    @Override
    public ConditionGenerator comparePointers(GimpleOp op, FatPtrExpr x, FatPtrExpr y) {
        return new FatPtrConditionGenerator(op, x, y);
    }

    @Override
    public SimpleExpr memoryCompare(FatPtrExpr p1, FatPtrExpr p2, SimpleExpr n) {
        return new FatPtrMemCmp(p1, p2, n);
    }

    @Override
    public void memoryCopy(MethodGenerator mv, FatPtrExpr destination, FatPtrExpr source, SimpleExpr lengthBytes) {
        SimpleExpr length = Expressions.divide(lengthBytes, this.valueFunction.getElementSize());
        source.getArray().load(mv);
        source.getOffset().load(mv);
        destination.getArray().load(mv);
        destination.getOffset().load(mv);
        length.load(mv);
        mv.invokestatic(System.class, "arraycopy", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), Type.INT_TYPE, Type.getType(Object.class), Type.INT_TYPE, Type.INT_TYPE}));
    }

    @Override
    public void memorySet(MethodGenerator mv, FatPtrExpr pointer, SimpleExpr byteValue, SimpleExpr length) {
        Type wrapperType = Wrappers.wrapperType(this.valueFunction.getValueType());
        Type arrayType = Wrappers.valueArrayType(this.valueFunction.getValueType());
        String methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{arrayType, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE});
        pointer.getArray().load(mv);
        pointer.getOffset().load(mv);
        byteValue.load(mv);
        length.load(mv);
        mv.invokestatic(wrapperType, "memset", methodDescriptor);
    }

    @Override
    public FatPtrExpr nullPointer() {
        return FatPtrExpr.nullPtr(this.valueFunction);
    }
}

