/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.var.LocalVarAllocator;

public class FatPtrReturnStrategy
implements ReturnStrategy {
    private ValueFunction valueFunction;

    public FatPtrReturnStrategy(ValueFunction valueFunction) {
        this.valueFunction = valueFunction;
    }

    @Override
    public Type getType() {
        return Wrappers.wrapperType(this.valueFunction.getValueType());
    }

    @Override
    public SimpleExpr marshall(Expr expr) {
        FatPtrExpr fatPtr = (FatPtrExpr)expr;
        return fatPtr.wrap();
    }

    @Override
    public Expr unmarshall(MethodGenerator mv, SimpleExpr returnValue) {
        LocalVarAllocator.LocalVar wrapper = mv.getLocalVarAllocator().reserve("retval", returnValue.getType());
        wrapper.store(mv, returnValue);
        SimpleExpr array = Wrappers.arrayField(wrapper, this.valueFunction.getValueType());
        SimpleExpr offset = Wrappers.offsetField(wrapper);
        return new FatPtrExpr(array, offset);
    }

    @Override
    public SimpleExpr getDefaultReturnValue() {
        Type arrayType = Wrappers.valueArrayType(this.valueFunction.getValueType());
        return new FatPtrExpr(Expressions.nullRef(arrayType)).wrap();
    }
}

