/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import com.google.bc.common.collect.Lists;
import java.util.ArrayList;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.primitive.ConstantValue;
import org.renjin.gcc.codegen.var.LocalVarAllocator;

public final class FatPtrMalloc {
    private static final int MAX_UNROLL_COUNT = 5;

    private FatPtrMalloc() {
    }

    public static FatPtrExpr alloc(MethodGenerator mv, ValueFunction valueFunction, SimpleExpr length) {
        return new FatPtrExpr(FatPtrMalloc.allocArray(mv, valueFunction, length));
    }

    public static SimpleExpr allocArray(MethodGenerator mv, ValueFunction valueFunction, SimpleExpr length) {
        ConstantValue constantLength;
        SimpleExpr totalLength = Expressions.product(length, valueFunction.getElementLength());
        if (!valueFunction.getValueConstructor().isPresent()) {
            return Expressions.newArray(valueFunction.getValueType(), totalLength);
        }
        if (length instanceof ConstantValue && (constantLength = (ConstantValue)length).getIntValue() <= 5) {
            ArrayList arrayValues = Lists.newArrayList();
            for (int i = 0; i < constantLength.getIntValue(); ++i) {
                arrayValues.add(valueFunction.getValueConstructor().get());
            }
            return Expressions.newArray(valueFunction.getValueType(), arrayValues);
        }
        Type arrayType = Wrappers.valueArrayType(valueFunction.getValueType());
        LocalVarAllocator.LocalVar array = mv.getLocalVarAllocator().reserve("$tmp$array", arrayType);
        LocalVarAllocator.LocalVar counter = mv.getLocalVarAllocator().reserve("$tmp$index", Type.INT_TYPE);
        totalLength.load(mv);
        mv.newarray(valueFunction.getValueType());
        mv.store(array.getIndex(), arrayType);
        mv.iconst(0);
        mv.store(counter.getIndex(), Type.INT_TYPE);
        Label loopHead = new Label();
        Label loopCheck = new Label();
        mv.goTo(loopCheck);
        mv.mark(loopHead);
        array.load(mv);
        counter.load(mv);
        ((SimpleExpr)valueFunction.getValueConstructor().get()).load(mv);
        mv.astore(valueFunction.getValueType());
        mv.iinc(counter.getIndex(), 1);
        mv.mark(loopCheck);
        mv.load(counter.getIndex(), Type.INT_TYPE);
        totalLength.load(mv);
        mv.ificmplt(loopHead);
        return array;
    }
}

