/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.FieldStrategy;

public class FatPtrFieldStrategy
extends FieldStrategy {
    private ValueFunction valueFunction;
    private String arrayField;
    private String offsetField;
    private Type arrayType;

    public FatPtrFieldStrategy(ValueFunction valueFunction, String name) {
        this.valueFunction = valueFunction;
        this.arrayField = name;
        this.arrayType = Wrappers.valueArrayType(valueFunction.getValueType());
        this.offsetField = name + "$offset";
    }

    @Override
    public void writeFields(ClassVisitor cv) {
        cv.visitField(1, this.arrayField, this.arrayType.getDescriptor(), null, null);
        cv.visitField(1, this.offsetField, "I", null, null);
    }

    @Override
    public Expr memberExprGenerator(SimpleExpr instance) {
        SimpleLValue array = Expressions.field(instance, this.arrayType, this.arrayField);
        SimpleLValue offset = Expressions.field(instance, Type.INT_TYPE, this.offsetField);
        return new FatPtrExpr(array, offset);
    }
}

