/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import com.google.bc.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Addressable;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.primitive.ConstantValue;

public final class FatPtrExpr
implements Expr,
LValue<FatPtrExpr>,
Addressable {
    private SimpleExpr array;
    private SimpleExpr offset;
    private Expr address;

    public FatPtrExpr(@Nullable Expr address, @Nonnull SimpleExpr array, @Nonnull SimpleExpr offset) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        Preconditions.checkNotNull((Object)offset, (Object)"offset");
        this.address = address;
        this.array = array;
        this.offset = offset;
    }

    public FatPtrExpr(@Nonnull SimpleExpr array, @Nonnull SimpleExpr offset) {
        this(null, array, offset);
    }

    public FatPtrExpr(SimpleExpr array) {
        this(array, Expressions.zero());
    }

    @Nonnull
    public SimpleExpr getArray() {
        return this.array;
    }

    @Nonnull
    public SimpleExpr getOffset() {
        return this.offset;
    }

    public Type getValueType() {
        String arrayDescriptor = this.array.getType().getDescriptor();
        Preconditions.checkState((boolean)arrayDescriptor.startsWith("["));
        return Type.getType((String)arrayDescriptor.substring(1));
    }

    @Override
    public void store(MethodGenerator mv, FatPtrExpr rhs) {
        if (!(this.array instanceof LValue)) {
            throw new InternalCompilerException(this.array + " is not an LValue");
        }
        ((LValue)((Object)this.array)).store(mv, rhs.getArray());
        if (this.offset instanceof ConstantValue && this.offset.equals(rhs.getOffset())) {
            return;
        }
        if (!(this.offset instanceof LValue)) {
            throw new InternalCompilerException(this.offset + " offset is not an Lvalue");
        }
        ((LValue)((Object)this.offset)).store(mv, rhs.getOffset());
    }

    public static FatPtrExpr nullPtr(ValueFunction valueFunction) {
        Type arrayType = Wrappers.valueArrayType(valueFunction.getValueType());
        SimpleExpr nullArray = Expressions.nullRef(arrayType);
        return new FatPtrExpr(nullArray);
    }

    public SimpleExpr wrap() {
        final Type wrapperType = Wrappers.wrapperType(this.getValueType());
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return wrapperType;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                mv.anew(wrapperType);
                mv.dup();
                FatPtrExpr.this.array.load(mv);
                FatPtrExpr.this.offset.load(mv);
                mv.invokeconstructor(wrapperType, Wrappers.fieldArrayType(wrapperType), FatPtrExpr.this.offset.getType());
            }
        };
    }

    @Override
    public Expr addressOf() {
        if (this.address == null) {
            throw new UnsupportedOperationException("Not addressable");
        }
        return this.address;
    }
}

