/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import org.objectweb.asm.Label;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.condition.ConditionGenerator;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.gimple.GimpleOp;

public class FatPtrConditionGenerator
implements ConditionGenerator {
    private GimpleOp op;
    private FatPtrExpr x;
    private FatPtrExpr y;

    public FatPtrConditionGenerator(GimpleOp op, FatPtrExpr x, FatPtrExpr y) {
        this.op = op;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitJump(MethodGenerator mv, Label trueLabel, Label falseLabel) {
        switch (this.op) {
            case EQ_EXPR: {
                this.jump(mv, trueLabel, falseLabel);
                break;
            }
            case NE_EXPR: {
                this.jump(mv, falseLabel, trueLabel);
                break;
            }
            default: {
                throw new UnsupportedOperationException("op: " + (Object)((Object)this.op));
            }
        }
    }

    private void jump(MethodGenerator mv, Label equalLabel, Label notEqualLabel) {
        this.x.getArray().load(mv);
        this.y.getArray().load(mv);
        mv.ifacmpne(notEqualLabel);
        this.x.getOffset().load(mv);
        this.y.getOffset().load(mv);
        mv.ificmpne(notEqualLabel);
        mv.goTo(equalLabel);
    }
}

