/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.fatptr;

import com.google.bc.common.base.Optional;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.type.FieldStrategy;

public class AddressableField
extends FieldStrategy {
    private final Type recordType;
    private final String arrayField;
    private final String offsetField;
    private final Type arrayType;
    private ValueFunction valueFunction;

    public AddressableField(Type recordType, String fieldName, ValueFunction valueFunction) {
        this.recordType = recordType;
        this.arrayField = fieldName;
        this.arrayType = Type.getType((String)("[" + valueFunction.getValueType().getDescriptor()));
        this.offsetField = fieldName + "$offset";
        this.valueFunction = valueFunction;
    }

    @Override
    public void writeFields(ClassVisitor cv) {
        cv.visitField(1, this.arrayField, this.arrayType.getDescriptor(), null, null);
        cv.visitField(1, this.offsetField, "I", null, null);
    }

    @Override
    public void emitInstanceInit(MethodGenerator mv) {
        Optional<SimpleExpr> initialValues = this.valueFunction.getValueConstructor();
        SimpleExpr unitArray = Expressions.newArray(this.valueFunction.getValueType(), this.valueFunction.getElementLength(), initialValues);
        mv.visitVarInsn(25, 0);
        unitArray.load(mv);
        mv.putfield(this.recordType, this.arrayField, this.arrayType);
    }

    @Override
    public Expr memberExprGenerator(SimpleExpr instance) {
        SimpleLValue array = Expressions.field(instance, this.arrayType, this.arrayField);
        SimpleLValue offset = Expressions.field(instance, Type.INT_TYPE, this.offsetField);
        return this.valueFunction.dereference(array, offset);
    }
}

