/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.expr;

import com.google.bc.common.base.Optional;
import com.google.bc.common.base.Preconditions;
import com.google.bc.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.WrapperType;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.type.primitive.ConstantValue;
import org.renjin.gcc.codegen.type.primitive.op.PrimitiveBinOpGenerator;
import org.renjin.gcc.gimple.GimpleOp;

public class Expressions {
    public static SimpleExpr newArray(Type componentType, int length) {
        return Expressions.newArray(componentType, Expressions.constantInt(length));
    }

    public static SimpleExpr newArray(WrapperType componentType, int length) {
        return Expressions.newArray(componentType.getWrapperType(), length);
    }

    public static SimpleExpr newArray(Class<?> componentClass, int length) {
        return Expressions.newArray(Type.getType(componentClass), length);
    }

    public static SimpleExpr newArray(final Type componentType, final SimpleExpr length) {
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return Type.getType((String)("[" + componentType.getDescriptor()));
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                length.load(mv);
                mv.newarray(componentType);
            }
        };
    }

    public static SimpleExpr newArray(SimpleExpr value, SimpleExpr ... moreValues) {
        ArrayList<SimpleExpr> values = new ArrayList<SimpleExpr>();
        values.add(value);
        values.addAll(Arrays.asList(moreValues));
        return Expressions.newArray(value.getType(), values);
    }

    public static SimpleExpr newArray(Type componentType, List<SimpleExpr> values) {
        return Expressions.newArray(componentType, values.size(), values);
    }

    public static SimpleExpr newArray(Type valueType, int elementLength, Optional<SimpleExpr> firstValue) {
        ArrayList initialValues = Lists.newArrayList();
        if (firstValue.isPresent()) {
            initialValues.add(firstValue.get());
        }
        return Expressions.newArray(valueType, elementLength, initialValues);
    }

    public static SimpleExpr newArray(final Type componentType, final int arrayLength, final List<SimpleExpr> values) {
        Preconditions.checkNotNull((Object)componentType, (Object)"componentType");
        if (values.size() > arrayLength) {
            throw new IllegalArgumentException(String.format("Number of initial values supplied (%d) is greater than array length (%d)", values.size(), arrayLength));
        }
        final Type arrayType = Type.getType((String)("[" + componentType.getDescriptor()));
        for (int i = 0; i < values.size(); ++i) {
            Type elementType = values.get(i).getType();
            if (elementType.getSort() == componentType.getSort()) continue;
            throw new IllegalArgumentException(String.format("Invalid type at element %d: %s, expected %s", i, elementType, componentType));
        }
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return arrayType;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                mv.iconst(arrayLength);
                mv.newarray(componentType);
                for (int i = 0; i < values.size(); ++i) {
                    mv.dup();
                    mv.iconst(i);
                    ((SimpleExpr)values.get(i)).load(mv);
                    mv.astore(componentType);
                }
            }
        };
    }

    public static SimpleExpr elementAt(SimpleExpr array, int offset) {
        return Expressions.elementAt(array, Expressions.constantInt(offset));
    }

    public static SimpleExpr elementAt(final SimpleExpr array, final SimpleExpr offset) {
        Expressions.checkType("array", array, 9);
        Expressions.checkType("offset", offset, Type.INT_TYPE);
        return new SimpleLValue(){

            @Override
            @Nonnull
            public Type getType() {
                return array.getType().getElementType();
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                array.load(mv);
                offset.load(mv);
                mv.aload(this.getType());
            }

            @Override
            public void store(MethodGenerator mv, SimpleExpr value) {
                array.load(mv);
                offset.load(mv);
                value.load(mv);
                mv.astore(this.getType());
            }
        };
    }

    public static SimpleExpr nullRef(final Type type) {
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return type;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                mv.aconst(null);
            }
        };
    }

    public static SimpleExpr constantInt(int value) {
        return new ConstantValue(Type.INT_TYPE, value);
    }

    public static SimpleExpr zero() {
        return Expressions.constantInt(0);
    }

    public static SimpleExpr zero(Type type) {
        return new ConstantValue(type, 0);
    }

    public static SimpleExpr sum(SimpleExpr x, SimpleExpr y) {
        return new PrimitiveBinOpGenerator(GimpleOp.PLUS_EXPR, x, y);
    }

    public static SimpleExpr difference(SimpleExpr x, SimpleExpr y) {
        return new PrimitiveBinOpGenerator(GimpleOp.MINUS_EXPR, x, y);
    }

    public static SimpleExpr difference(SimpleExpr x, int y) {
        if (y == 0) {
            return x;
        }
        return Expressions.difference(x, Expressions.constantInt(y));
    }

    public static SimpleExpr product(SimpleExpr x, SimpleExpr y) {
        return new PrimitiveBinOpGenerator(GimpleOp.MULT_EXPR, x, y);
    }

    public static SimpleExpr product(SimpleExpr x, int y) {
        Preconditions.checkArgument((boolean)x.getType().equals((Object)Type.INT_TYPE));
        if (y == 0) {
            return Expressions.zero(x.getType());
        }
        if (y == 1) {
            return x;
        }
        return Expressions.product(x, Expressions.constantInt(y));
    }

    public static SimpleExpr divide(SimpleExpr x, SimpleExpr y) {
        return new PrimitiveBinOpGenerator(GimpleOp.EXACT_DIV_EXPR, x, y);
    }

    public static SimpleExpr divide(SimpleExpr size, int divisor) {
        Preconditions.checkArgument((boolean)size.getType().equals((Object)Type.INT_TYPE));
        return Expressions.divide(size, Expressions.constantInt(divisor));
    }

    public static SimpleLValue field(final SimpleExpr instance, final Type fieldType, final String fieldName) {
        Expressions.checkType("instance", instance, 10);
        return new SimpleLValue(){

            @Override
            @Nonnull
            public Type getType() {
                return fieldType;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                instance.load(mv);
                mv.getfield(instance.getType().getInternalName(), fieldName, fieldType.getDescriptor());
            }

            @Override
            public void store(MethodGenerator mv, SimpleExpr value) {
                instance.load(mv);
                value.load(mv);
                mv.putfield(instance.getType().getInternalName(), fieldName, fieldType.getDescriptor());
            }
        };
    }

    private static void checkType(String argName, SimpleExpr value, int expectedSort) {
        if (value.getType().getSort() != expectedSort) {
            throw new IllegalArgumentException(String.format("Illegal type for %s: %s", argName, value.getType()));
        }
    }

    private static void checkType(String argName, SimpleExpr value, Type expectedType) {
        if (!value.getType().equals((Object)expectedType)) {
            throw new IllegalArgumentException(String.format("Illegal type %s for %s: Expected %s", value.getType(), argName, expectedType));
        }
    }

    public static SimpleExpr cast(final SimpleExpr object, final Type type) {
        if (object.getType().equals((Object)type)) {
            return object;
        }
        Expressions.checkCast(object.getType(), type);
        return new SimpleLValue(){

            @Override
            @Nonnull
            public Type getType() {
                return type;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                object.load(mv);
                mv.checkcast(type);
            }

            @Override
            public void store(MethodGenerator mv, SimpleExpr value) {
                if (!(object instanceof LValue)) {
                    throw new UnsupportedOperationException();
                }
                ((LValue)((Object)object)).store(mv, value);
            }
        };
    }

    private static void checkCast(Type fromType, Type toType) {
        int toSort;
        if (toType.getSort() != 10 && toType.getSort() != 9) {
            throw new IllegalArgumentException("Target type for cast must be an array or object: " + toType);
        }
        int fromSort = fromType.getSort();
        if (fromSort != (toSort = toType.getSort())) {
            throw new IllegalArgumentException("Invalid cast from " + fromType + " to " + toType);
        }
        if (fromSort == 9) {
            Expressions.checkCast(fromType.getElementType(), toType.getElementType());
        }
    }

    public static SimpleExpr voidValue() {
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return Type.VOID_TYPE;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
            }
        };
    }

    public static SimpleExpr thisValue(final Type type) {
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return type;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                mv.load(0, type);
            }
        };
    }

    public static boolean isPrimitive(SimpleExpr simpleExpr) {
        return Expressions.isPrimitive(simpleExpr.getType());
    }

    public static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: {
                return false;
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static SimpleExpr box(final SimpleExpr simpleExpr) {
        Preconditions.checkArgument((boolean)Expressions.isPrimitive(simpleExpr), (Object)"simpleExpr must be a primitive");
        Type primitiveType = simpleExpr.getType();
        final Type boxedType = Expressions.boxedType(primitiveType);
        final String valueOfDescriptor = Type.getMethodDescriptor((Type)boxedType, (Type[])new Type[]{primitiveType});
        return new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return boxedType;
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                simpleExpr.load(mv);
                mv.invokestatic(boxedType.getInternalName(), "valueOf", valueOfDescriptor, false);
            }
        };
    }

    public static Type boxedType(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Type.getType(Boolean.class);
            }
            case 3: {
                return Type.getType(Byte.class);
            }
            case 4: {
                return Type.getType(Short.class);
            }
            case 2: {
                return Type.getType(Character.class);
            }
            case 5: {
                return Type.getType(Integer.class);
            }
            case 7: {
                return Type.getType(Long.class);
            }
            case 6: {
                return Type.getType(Float.class);
            }
            case 8: {
                return Type.getType(Double.class);
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }
}

