/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.expr;

import java.util.List;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.array.ArrayTypeStrategy;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.call.FunPtrCallGenerator;
import org.renjin.gcc.codegen.condition.ConditionGenerator;
import org.renjin.gcc.codegen.expr.Addressable;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleAddressableExpr;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.type.PointerTypeStrategy;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.codegen.type.complex.ComplexCmpGenerator;
import org.renjin.gcc.codegen.type.complex.ComplexValue;
import org.renjin.gcc.codegen.type.complex.ComplexValues;
import org.renjin.gcc.codegen.type.fun.FunctionRefGenerator;
import org.renjin.gcc.codegen.type.primitive.ConstantValue;
import org.renjin.gcc.codegen.type.primitive.PrimitiveCmpGenerator;
import org.renjin.gcc.codegen.type.primitive.StringConstant;
import org.renjin.gcc.codegen.type.primitive.op.AbsValue;
import org.renjin.gcc.codegen.type.primitive.op.BitwiseNot;
import org.renjin.gcc.codegen.type.primitive.op.BitwiseShift;
import org.renjin.gcc.codegen.type.primitive.op.CastGenerator;
import org.renjin.gcc.codegen.type.primitive.op.ConditionExpr;
import org.renjin.gcc.codegen.type.primitive.op.LogicalAnd;
import org.renjin.gcc.codegen.type.primitive.op.LogicalNot;
import org.renjin.gcc.codegen.type.primitive.op.LogicalOr;
import org.renjin.gcc.codegen.type.primitive.op.LogicalXor;
import org.renjin.gcc.codegen.type.primitive.op.MinMaxValue;
import org.renjin.gcc.codegen.type.primitive.op.NegativeValue;
import org.renjin.gcc.codegen.type.primitive.op.PrimitiveBinOpGenerator;
import org.renjin.gcc.codegen.type.primitive.op.UnorderedExpr;
import org.renjin.gcc.codegen.type.record.RecordClassTypeStrategy;
import org.renjin.gcc.codegen.type.record.RecordTypeStrategy;
import org.renjin.gcc.gimple.CallingConvention;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.expr.GimpleAddressOf;
import org.renjin.gcc.gimple.expr.GimpleArrayRef;
import org.renjin.gcc.gimple.expr.GimpleComplexConstant;
import org.renjin.gcc.gimple.expr.GimpleComplexPartExpr;
import org.renjin.gcc.gimple.expr.GimpleComponentRef;
import org.renjin.gcc.gimple.expr.GimpleConstant;
import org.renjin.gcc.gimple.expr.GimpleConstantRef;
import org.renjin.gcc.gimple.expr.GimpleConstructor;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleFunctionRef;
import org.renjin.gcc.gimple.expr.GimpleMemRef;
import org.renjin.gcc.gimple.expr.GimpleNopExpr;
import org.renjin.gcc.gimple.expr.GimplePrimitiveConstant;
import org.renjin.gcc.gimple.expr.GimpleRealPartExpr;
import org.renjin.gcc.gimple.expr.GimpleStringConstant;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.gimple.type.GimpleComplexType;
import org.renjin.gcc.gimple.type.GimpleFunctionType;
import org.renjin.gcc.gimple.type.GimpleIndirectType;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;
import org.renjin.gcc.gimple.type.GimpleRecordType;
import org.renjin.gcc.gimple.type.GimpleType;
import org.renjin.gcc.gimple.type.GimpleVoidType;
import org.renjin.gcc.symbols.SymbolTable;

public class ExprFactory {
    private final TypeOracle typeOracle;
    private final SymbolTable symbolTable;
    private final CallingConvention callingConvention;

    public ExprFactory(TypeOracle typeOracle, SymbolTable symbolTable, CallingConvention callingConvention) {
        this.typeOracle = typeOracle;
        this.symbolTable = symbolTable;
        this.callingConvention = callingConvention;
    }

    public Expr findGenerator(GimpleExpr expr, GimpleType expectedType) {
        return this.maybeCast(this.findGenerator(expr), expectedType, expr.getType());
    }

    public Expr maybeCast(Expr rhs, GimpleType lhsType, GimpleType rhsType) {
        if (lhsType instanceof GimplePrimitiveType) {
            if (rhsType instanceof GimplePrimitiveType && !lhsType.equals(rhsType)) {
                return new CastGenerator((SimpleExpr)rhs, (GimplePrimitiveType)rhsType, (GimplePrimitiveType)lhsType);
            }
        } else if (lhsType.isPointerTo(GimpleRecordType.class) && rhsType.isPointerTo(GimpleVoidType.class)) {
            GimpleRecordType recordType = (GimpleRecordType)lhsType.getBaseType();
            return ((RecordClassTypeStrategy)this.typeOracle.forType(recordType)).voidCast(rhs);
        }
        return rhs;
    }

    public Expr findGenerator(GimpleExpr expr) {
        if (expr instanceof GimpleSymbolRef) {
            Expr variable = this.symbolTable.getVariable((GimpleSymbolRef)((Object)expr));
            if (variable == null) {
                throw new InternalCompilerException("No such variable: " + expr);
            }
            return variable;
        }
        if (expr instanceof GimpleConstant) {
            return this.forConstant((GimpleConstant)expr);
        }
        if (expr instanceof GimpleConstructor) {
            return this.forConstructor((GimpleConstructor)expr);
        }
        if (expr instanceof GimpleNopExpr) {
            return this.findGenerator(((GimpleNopExpr)expr).getValue(), expr.getType());
        }
        if (expr instanceof GimpleAddressOf) {
            GimpleAddressOf addressOf = (GimpleAddressOf)expr;
            if (addressOf.getValue() instanceof GimpleFunctionRef) {
                GimpleFunctionRef functionRef = (GimpleFunctionRef)addressOf.getValue();
                return new FunctionRefGenerator(this.symbolTable.findHandle(functionRef, this.callingConvention));
            }
            if (addressOf.getValue() instanceof GimplePrimitiveConstant) {
                SimpleExpr value = this.findValueGenerator(addressOf.getValue());
                return new FatPtrExpr(Expressions.newArray(value, new SimpleExpr[0]));
            }
            Expr value = this.findGenerator(addressOf.getValue());
            try {
                return ((Addressable)value).addressOf();
            }
            catch (ClassCastException | UnsupportedOperationException ignored) {
                throw new InternalCompilerException(addressOf.getValue() + " [" + value.getClass().getName() + "] is not addressable");
            }
        }
        if (expr instanceof GimpleMemRef) {
            GimpleMemRef memRefExpr = (GimpleMemRef)expr;
            PointerTypeStrategy typeStrategy = this.typeOracle.forPointerType(memRefExpr.getPointer().getType());
            Expr ptrGenerator = this.findGenerator(memRefExpr.getPointer());
            if (!memRefExpr.isOffsetZero()) {
                SimpleExpr offsetInBytes = this.findValueGenerator(memRefExpr.getOffset());
                ptrGenerator = typeStrategy.pointerPlus(ptrGenerator, offsetInBytes);
            }
            return typeStrategy.valueOf(ptrGenerator);
        }
        if (expr instanceof GimpleArrayRef) {
            GimpleArrayRef arrayRef = (GimpleArrayRef)expr;
            ArrayTypeStrategy arrayStrategy = this.typeOracle.forArrayType(arrayRef.getArray().getType());
            Expr array = this.findGenerator(arrayRef.getArray());
            Expr index = this.findGenerator(arrayRef.getIndex());
            return arrayStrategy.elementAt(array, index);
        }
        if (expr instanceof GimpleConstantRef) {
            GimpleConstant constant = ((GimpleConstantRef)expr).getValue();
            SimpleExpr constantValue = this.findValueGenerator(constant);
            FatPtrExpr address = new FatPtrExpr(Expressions.newArray(constantValue, new SimpleExpr[0]));
            return new SimpleAddressableExpr(constantValue, address);
        }
        if (expr instanceof GimpleComplexPartExpr) {
            GimpleExpr complexExpr = ((GimpleComplexPartExpr)expr).getComplexValue();
            ComplexValue complexGenerator = (ComplexValue)this.findGenerator(complexExpr);
            if (expr instanceof GimpleRealPartExpr) {
                return complexGenerator.getRealValue();
            }
            return complexGenerator.getImaginaryValue();
        }
        if (expr instanceof GimpleComponentRef) {
            GimpleComponentRef ref = (GimpleComponentRef)expr;
            Expr instance = this.findGenerator(((GimpleComponentRef)expr).getValue());
            RecordTypeStrategy typeStrategy = (RecordTypeStrategy)this.typeOracle.forType(ref.getValue().getType());
            return typeStrategy.memberOf(instance, ref.getMember());
        }
        throw new UnsupportedOperationException(expr + " [" + expr.getClass().getSimpleName() + "]");
    }

    private Expr forConstructor(GimpleConstructor expr) {
        return this.typeOracle.forType(expr.getType()).constructorExpr(this, expr);
    }

    public CallGenerator findCallGenerator(GimpleExpr functionExpr, List<GimpleExpr> operands) {
        if (functionExpr instanceof GimpleAddressOf) {
            GimpleAddressOf addressOf = (GimpleAddressOf)functionExpr;
            if (addressOf.getValue() instanceof GimpleFunctionRef) {
                GimpleFunctionRef ref = (GimpleFunctionRef)addressOf.getValue();
                return this.symbolTable.findCallGenerator(ref, operands, this.callingConvention);
            }
            GimpleAddressOf address = (GimpleAddressOf)functionExpr;
            throw new UnsupportedOperationException("function ref: " + address.getValue() + " [" + address.getValue().getClass().getSimpleName() + "]");
        }
        Expr expr = this.findGenerator(functionExpr);
        return new FunPtrCallGenerator(this.typeOracle, (GimpleFunctionType)functionExpr.getType().getBaseType(), (SimpleExpr)expr);
    }

    public ConditionGenerator findConditionGenerator(GimpleOp op, List<GimpleExpr> operands) {
        if (operands.size() == 2) {
            return this.findComparisonGenerator(op, operands.get(0), operands.get(1));
        }
        throw new UnsupportedOperationException();
    }

    private ConditionGenerator findComparisonGenerator(GimpleOp op, GimpleExpr x, GimpleExpr y) {
        if (x.getType() instanceof GimpleComplexType) {
            return new ComplexCmpGenerator(op, this.findComplexGenerator(x), this.findComplexGenerator(y));
        }
        if (x.getType() instanceof GimplePrimitiveType) {
            return new PrimitiveCmpGenerator(op, this.findValueGenerator(x), this.findValueGenerator(y));
        }
        if (x.getType() instanceof GimpleIndirectType) {
            return this.comparePointers(op, x, y);
        }
        throw new UnsupportedOperationException("Unsupported comparison " + (Object)((Object)op) + " between types " + x.getType() + " and " + y.getType());
    }

    private ConditionGenerator comparePointers(GimpleOp op, GimpleExpr x, GimpleExpr y) {
        if (!x.getType().equals(y.getType())) {
            throw new InternalCompilerException(String.format("pointer comparison types do not match: %s != %s", x.getType(), y.getType()));
        }
        Expr ptrX = this.findGenerator(x);
        Expr ptrY = this.findGenerator(y);
        return this.typeOracle.forPointerType(x.getType()).comparePointers(op, ptrX, ptrY);
    }

    public Expr findGenerator(GimpleOp op, List<GimpleExpr> operands, GimpleType expectedType) {
        switch (op) {
            case PLUS_EXPR: 
            case MINUS_EXPR: 
            case MULT_EXPR: 
            case RDIV_EXPR: 
            case TRUNC_DIV_EXPR: 
            case EXACT_DIV_EXPR: 
            case TRUNC_MOD_EXPR: 
            case BIT_IOR_EXPR: 
            case BIT_XOR_EXPR: 
            case BIT_AND_EXPR: {
                return this.findBinOpGenerator(op, operands);
            }
            case POINTER_PLUS_EXPR: {
                return this.pointerPlus(operands.get(0), operands.get(1));
            }
            case BIT_NOT_EXPR: {
                return new BitwiseNot((SimpleExpr)this.findGenerator(operands.get(0)));
            }
            case LSHIFT_EXPR: 
            case RSHIFT_EXPR: {
                return new BitwiseShift(op, operands.get(0).getType(), (SimpleExpr)this.findGenerator(operands.get(0)), (SimpleExpr)this.findGenerator(operands.get(1)));
            }
            case CONVERT_EXPR: 
            case FIX_TRUNC_EXPR: 
            case FLOAT_EXPR: 
            case PAREN_EXPR: 
            case VAR_DECL: 
            case PARM_DECL: 
            case NOP_EXPR: 
            case MEM_REF: 
            case INTEGER_CST: 
            case REAL_CST: 
            case STRING_CST: 
            case COMPLEX_CST: 
            case ADDR_EXPR: 
            case ARRAY_REF: 
            case COMPONENT_REF: 
            case REALPART_EXPR: 
            case IMAGPART_EXPR: {
                return this.maybeCast(this.findGenerator(operands.get(0)), expectedType, operands.get(0).getType());
            }
            case COMPLEX_EXPR: {
                return new ComplexValue(this.findValueGenerator(operands.get(0)));
            }
            case NEGATE_EXPR: {
                return new NegativeValue(this.findValueGenerator(operands.get(0)));
            }
            case TRUTH_NOT_EXPR: {
                return new LogicalNot(this.findValueGenerator(operands.get(0)));
            }
            case TRUTH_AND_EXPR: {
                return new LogicalAnd(this.findValueGenerator(operands.get(0)), this.findValueGenerator(operands.get(1)));
            }
            case TRUTH_OR_EXPR: {
                return new LogicalOr(this.findValueGenerator(operands.get(0)), this.findValueGenerator(operands.get(1)));
            }
            case TRUTH_XOR_EXPR: {
                return new LogicalXor(this.findValueGenerator(operands.get(0)), this.findValueGenerator(operands.get(1)));
            }
            case EQ_EXPR: 
            case LT_EXPR: 
            case LE_EXPR: 
            case NE_EXPR: 
            case GT_EXPR: 
            case GE_EXPR: {
                return new ConditionExpr(this.findComparisonGenerator(op, operands.get(0), operands.get(1)));
            }
            case MAX_EXPR: 
            case MIN_EXPR: {
                return new MinMaxValue(op, this.findValueGenerator(operands.get(0)), this.findValueGenerator(operands.get(1)));
            }
            case ABS_EXPR: {
                return new AbsValue(this.findValueGenerator(operands.get(0)));
            }
            case UNORDERED_EXPR: {
                return new UnorderedExpr(this.findValueGenerator(operands.get(0)), this.findValueGenerator(operands.get(1)));
            }
            case CONJ_EXPR: {
                return this.findComplexGenerator(operands.get(0)).conjugate();
            }
        }
        throw new UnsupportedOperationException("op: " + (Object)((Object)op));
    }

    private Expr pointerPlus(GimpleExpr pointerExpr, GimpleExpr offsetExpr) {
        Expr pointer = this.findGenerator(pointerExpr);
        SimpleExpr offsetInBytes = this.findValueGenerator(offsetExpr);
        return this.typeOracle.forPointerType(pointerExpr.getType()).pointerPlus(pointer, offsetInBytes);
    }

    private <T extends Expr> T findGenerator(GimpleExpr gimpleExpr, Class<T> exprClass) {
        Expr expr = this.findGenerator(gimpleExpr);
        if (exprClass.isAssignableFrom(expr.getClass())) {
            return (T)((Expr)exprClass.cast(expr));
        }
        throw new InternalCompilerException(String.format("Expected %s for expr %s, found: %s", exprClass.getSimpleName(), gimpleExpr, expr.getClass().getName()));
    }

    public SimpleExpr findValueGenerator(GimpleExpr gimpleExpr) {
        if (gimpleExpr instanceof GimplePrimitiveConstant && gimpleExpr.getType() instanceof GimpleIndirectType) {
            return Expressions.constantInt(((GimplePrimitiveConstant)gimpleExpr).getValue().intValue());
        }
        return this.findGenerator(gimpleExpr, SimpleExpr.class);
    }

    private ComplexValue findComplexGenerator(GimpleExpr gimpleExpr) {
        return this.findGenerator(gimpleExpr, ComplexValue.class);
    }

    private Expr findBinOpGenerator(GimpleOp op, List<GimpleExpr> operands) {
        GimpleExpr x = operands.get(0);
        GimpleExpr y = operands.get(1);
        if (x.getType() instanceof GimpleComplexType && y.getType() instanceof GimpleComplexType) {
            return this.complexBinOp(op, this.findComplexGenerator(x), this.findComplexGenerator(y));
        }
        if (x.getType() instanceof GimplePrimitiveType && y.getType() instanceof GimplePrimitiveType) {
            return new PrimitiveBinOpGenerator(op, this.findValueGenerator(x), this.findValueGenerator(y));
        }
        throw new UnsupportedOperationException(op.name() + ": " + x.getType() + ", " + y.getType());
    }

    private Expr complexBinOp(GimpleOp op, ComplexValue cx, ComplexValue cy) {
        switch (op) {
            case PLUS_EXPR: {
                return ComplexValues.add(cx, cy);
            }
            case MINUS_EXPR: {
                return ComplexValues.subtract(cx, cy);
            }
            case MULT_EXPR: {
                return ComplexValues.multiply(cx, cy);
            }
        }
        throw new UnsupportedOperationException("op: " + (Object)((Object)op));
    }

    public Expr forConstant(GimpleConstant constant) {
        if (constant.isNull()) {
            return this.typeOracle.forPointerType(constant.getType()).nullPointer();
        }
        if (constant instanceof GimplePrimitiveConstant) {
            return new ConstantValue((GimplePrimitiveConstant)constant);
        }
        if (constant instanceof GimpleComplexConstant) {
            GimpleComplexConstant complexConstant = (GimpleComplexConstant)constant;
            return new ComplexValue((SimpleExpr)this.forConstant(complexConstant.getReal()), (SimpleExpr)this.forConstant(complexConstant.getIm()));
        }
        if (constant instanceof GimpleStringConstant) {
            StringConstant array = new StringConstant(((GimpleStringConstant)constant).getValue());
            FatPtrExpr address = new FatPtrExpr(array);
            FatPtrExpr arrayExpr = new FatPtrExpr(address, array, Expressions.zero());
            return arrayExpr;
        }
        throw new UnsupportedOperationException("constant: " + constant);
    }
}

