/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.call;

import java.lang.reflect.Method;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.call.InvocationStrategy;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.TypeOracle;

public class StaticMethodStrategy
implements InvocationStrategy {
    private final TypeOracle typeOracle;
    private Method method;
    private List<ParamStrategy> paramStrategies;
    private ReturnStrategy returnStrategy;

    public StaticMethodStrategy(TypeOracle typeOracle, Method method) {
        this.typeOracle = typeOracle;
        this.method = method;
    }

    @Override
    public Handle getMethodHandle() {
        return new Handle(6, Type.getInternalName(this.method.getDeclaringClass()), this.method.getName(), Type.getMethodDescriptor((Method)this.method));
    }

    @Override
    public List<ParamStrategy> getParamStrategies() {
        if (this.paramStrategies == null) {
            this.paramStrategies = this.typeOracle.forParameterTypesOf(this.method);
        }
        return this.paramStrategies;
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    public ReturnStrategy getReturnStrategy() {
        if (this.returnStrategy == null) {
            this.returnStrategy = this.typeOracle.forReturnValue(this.method);
        }
        return this.returnStrategy;
    }

    @Override
    public void invoke(MethodGenerator mv) {
        mv.invokestatic(this.method.getDeclaringClass(), this.method.getName(), Type.getMethodDescriptor((Method)this.method));
    }
}

