/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.call;

import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.type.GimpleType;

public class ReallocCallGenerator
implements CallGenerator {
    private TypeOracle typeOracle;

    public ReallocCallGenerator(TypeOracle typeOracle) {
        this.typeOracle = typeOracle;
    }

    @Override
    public void emitCall(MethodGenerator mv, ExprFactory exprFactory, GimpleCall call) {
        if (call.getLhs() == null) {
            return;
        }
        GimpleType pointerType = call.getLhs().getType();
        Expr pointer = exprFactory.findGenerator(call.getOperand(0));
        SimpleExpr size = exprFactory.findValueGenerator(call.getOperand(1));
        SimpleExpr length = Expressions.divide(size, pointerType.getBaseType().sizeOf());
        Expr reallocatedPointer = this.typeOracle.forPointerType(pointerType).realloc(pointer, length);
        LValue lhs = (LValue)((Object)exprFactory.findGenerator(call.getLhs()));
        lhs.store(mv, reallocatedPointer);
    }
}

