/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.call;

import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.type.GimpleType;

public class MallocCallGenerator
implements CallGenerator {
    private TypeOracle typeOracle;

    public MallocCallGenerator(TypeOracle typeOracle) {
        this.typeOracle = typeOracle;
    }

    @Override
    public void emitCall(MethodGenerator mv, ExprFactory exprFactory, GimpleCall call) {
        if (call.getLhs() == null) {
            return;
        }
        GimpleType pointerType = call.getLhs().getType();
        SimpleExpr size = exprFactory.findValueGenerator(call.getOperands().get(0));
        SimpleExpr length = Expressions.divide(size, pointerType.getBaseType().sizeOf());
        Object mallocGenerator = this.typeOracle.forPointerType(pointerType).malloc(mv, length);
        LValue lhs = (LValue)((Object)exprFactory.findGenerator(call.getLhs()));
        lhs.store(mv, mallocGenerator);
    }
}

