/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.call;

import com.google.bc.common.base.Optional;
import com.google.bc.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.call.InvocationStrategy;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.gimple.statement.GimpleCall;

public class FunctionCallGenerator
implements CallGenerator {
    private final InvocationStrategy strategy;

    public FunctionCallGenerator(InvocationStrategy invocationStrategy) {
        this.strategy = invocationStrategy;
    }

    public InvocationStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void emitCall(MethodGenerator mv, ExprFactory exprFactory, GimpleCall call) {
        int fixedArgCount = this.strategy.getParamStrategies().size();
        if (call.getOperands().size() < fixedArgCount) {
            throw new InternalCompilerException(String.format("Number of provided arguments (%d) does not match number of expected arguments (%d) for " + this.strategy, call.getOperands().size(), fixedArgCount));
        }
        ArrayList argumentExpressions = Lists.newArrayList();
        for (int i = 0; i < fixedArgCount; ++i) {
            argumentExpressions.add(exprFactory.findGenerator(call.getOperand(i)));
        }
        Optional varArgArray = Optional.absent();
        if (this.strategy.isVarArgs()) {
            ArrayList varArgValues = Lists.newArrayList();
            for (int i = fixedArgCount; i < call.getOperands().size(); ++i) {
                Expr varArgExpr = exprFactory.findGenerator(call.getOperand(i));
                varArgValues.add(this.wrapVarArg(varArgExpr));
            }
            varArgArray = Optional.of((Object)Expressions.newArray(Type.getType(Object.class), varArgValues));
        }
        CallExpr returnValue = new CallExpr(argumentExpressions, (Optional<SimpleExpr>)varArgArray);
        if (call.getLhs() == null) {
            returnValue.load(mv);
            mv.pop(returnValue.getType());
        } else {
            Expr callExpr = this.strategy.getReturnStrategy().unmarshall(mv, returnValue);
            LValue lhs = (LValue)((Object)exprFactory.findGenerator(call.getLhs()));
            lhs.store(mv, callExpr);
        }
    }

    private SimpleExpr wrapVarArg(Expr varArgExpr) {
        if (varArgExpr instanceof SimpleExpr) {
            SimpleExpr simpleExpr = (SimpleExpr)varArgExpr;
            if (Expressions.isPrimitive(simpleExpr)) {
                return Expressions.box(simpleExpr);
            }
            return simpleExpr;
        }
        if (varArgExpr instanceof FatPtrExpr) {
            return ((FatPtrExpr)varArgExpr).wrap();
        }
        throw new UnsupportedOperationException("varArgExpr: " + varArgExpr);
    }

    private class CallExpr
    implements SimpleExpr {
        private List<Expr> arguments;
        private Optional<SimpleExpr> varArgArray;

        public CallExpr(List<Expr> arguments, Optional<SimpleExpr> varArgArray) {
            this.arguments = arguments;
            this.varArgArray = varArgArray;
        }

        @Override
        @Nonnull
        public Type getType() {
            return FunctionCallGenerator.this.strategy.getReturnStrategy().getType();
        }

        @Override
        public void load(@Nonnull MethodGenerator mv) {
            List<ParamStrategy> paramStrategies = FunctionCallGenerator.this.strategy.getParamStrategies();
            for (int i = 0; i < paramStrategies.size(); ++i) {
                ParamStrategy paramStrategy = paramStrategies.get(i);
                paramStrategy.loadParameter(mv, this.arguments.get(i));
            }
            if (this.varArgArray.isPresent()) {
                ((SimpleExpr)this.varArgArray.get()).load(mv);
            }
            FunctionCallGenerator.this.strategy.invoke(mv);
        }
    }
}

