/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.call;

import com.google.bc.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.codegen.type.voidt.VoidReturnStrategy;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.type.GimpleFunctionType;

public class FunPtrCallGenerator
implements CallGenerator {
    private TypeOracle typeOracle;
    private SimpleExpr methodHandle;
    private final ReturnStrategy returnStrategy;
    private final GimpleFunctionType functionType;

    public FunPtrCallGenerator(TypeOracle typeOracle, GimpleFunctionType type, SimpleExpr methodHandle) {
        this.typeOracle = typeOracle;
        this.methodHandle = methodHandle;
        this.functionType = type;
        this.returnStrategy = typeOracle.returnStrategyFor(this.functionType.getReturnType());
    }

    @Override
    public void emitCall(MethodGenerator mv, final ExprFactory exprFactory, final GimpleCall call) {
        final ArrayList paramStrategies = Lists.newArrayList();
        for (GimpleExpr argumentExpr : call.getOperands()) {
            paramStrategies.add(this.typeOracle.forParameter(argumentExpr.getType()));
        }
        final ReturnStrategy returnStrategy = call.getLhs() == null ? new VoidReturnStrategy() : this.typeOracle.returnStrategyFor(call.getLhs().getType());
        final String signature = TypeOracle.getMethodDescriptor(returnStrategy, paramStrategies);
        SimpleExpr callValue = new SimpleExpr(){

            @Override
            @Nonnull
            public Type getType() {
                return returnStrategy.getType();
            }

            @Override
            public void load(@Nonnull MethodGenerator mv) {
                FunPtrCallGenerator.this.methodHandle.load(mv);
                for (int i = 0; i < call.getOperands().size(); ++i) {
                    ((ParamStrategy)paramStrategies.get(i)).loadParameter(mv, exprFactory.findGenerator(call.getOperand(i)));
                }
                mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invoke", signature, false);
            }
        };
        if (call.getLhs() == null) {
            callValue.load(mv);
        } else {
            LValue lhs = (LValue)((Object)exprFactory.findGenerator(call.getLhs()));
            Expr rhs = returnStrategy.unmarshall(mv, callValue);
            lhs.store(mv, rhs);
        }
    }
}

