/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.array;

import com.google.bc.common.base.Optional;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.ValueFunction;

public class ArrayValueFunction
implements ValueFunction {
    private final ValueFunction elementValueFunction;

    public ArrayValueFunction(ValueFunction elementValueFunction) {
        this.elementValueFunction = elementValueFunction;
    }

    @Override
    public Type getValueType() {
        return this.elementValueFunction.getValueType();
    }

    @Override
    public int getElementLength() {
        return this.elementValueFunction.getElementLength();
    }

    @Override
    public int getElementSize() {
        return this.elementValueFunction.getElementSize();
    }

    @Override
    public Expr dereference(SimpleExpr array, SimpleExpr offset) {
        return new FatPtrExpr(array, offset);
    }

    @Override
    public List<SimpleExpr> toArrayValues(Expr expr) {
        FatPtrExpr fatPtrExpr = (FatPtrExpr)expr;
        return Collections.singletonList(fatPtrExpr.wrap());
    }

    @Override
    public Optional<SimpleExpr> getValueConstructor() {
        return this.elementValueFunction.getValueConstructor();
    }
}

