/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.array;

import com.google.bc.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.array.ArrayField;
import org.renjin.gcc.codegen.array.ArrayValueFunction;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrStrategy;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.FieldStrategy;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.TypeStrategy;
import org.renjin.gcc.codegen.var.VarAllocator;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleConstructor;
import org.renjin.gcc.gimple.type.GimpleArrayType;

public class ArrayTypeStrategy
implements TypeStrategy<FatPtrExpr> {
    private final ValueFunction valueFunction;
    private GimpleArrayType arrayType;
    private boolean parameterWrapped = true;

    public ArrayTypeStrategy(GimpleArrayType arrayType, ValueFunction valueFunction) {
        this.arrayType = arrayType;
        this.valueFunction = valueFunction;
    }

    public boolean isParameterWrapped() {
        return this.parameterWrapped;
    }

    public ArrayTypeStrategy setParameterWrapped(boolean parameterWrapped) {
        this.parameterWrapped = parameterWrapped;
        return this;
    }

    @Override
    public FatPtrStrategy pointerTo() {
        return new FatPtrStrategy(new ArrayValueFunction(this.valueFunction)).setParametersWrapped(this.parameterWrapped);
    }

    @Override
    public ArrayTypeStrategy arrayOf(GimpleArrayType arrayType) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public FatPtrExpr constructorExpr(ExprFactory exprFactory, GimpleConstructor constructor) {
        ArrayList values = Lists.newArrayList();
        for (GimpleConstructor.Element element : constructor.getElements()) {
            Expr elementExpr = exprFactory.findGenerator(element.getValue());
            List<SimpleExpr> arrayValues = this.valueFunction.toArrayValues(elementExpr);
            assert (arrayValues.size() == this.valueFunction.getElementLength());
            values.addAll(arrayValues);
        }
        SimpleExpr array = Expressions.newArray(this.valueFunction.getValueType(), values);
        SimpleExpr offset = Expressions.zero();
        return new FatPtrExpr(array, offset);
    }

    @Override
    public FieldStrategy fieldGenerator(Type className, String fieldName) {
        return new ArrayField(className, fieldName, this.arrayType.getElementCount(), this.valueFunction);
    }

    @Override
    public FieldStrategy addressableFieldGenerator(Type className, String fieldName) {
        return this.fieldGenerator(className, fieldName);
    }

    @Override
    public ParamStrategy getParamStrategy() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public ReturnStrategy getReturnStrategy() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public FatPtrExpr variable(GimpleVarDecl decl, VarAllocator allocator) {
        Type arrayType = Wrappers.valueArrayType(this.valueFunction.getValueType());
        int arrayLength = ((GimpleArrayType)decl.getType()).getElementCount();
        SimpleLValue array = decl.getValue() == null ? allocator.reserve(decl.getName(), arrayType, this.allocArray(arrayLength)) : allocator.reserve(decl.getName(), arrayType);
        SimpleExpr offset = Expressions.zero();
        return new FatPtrExpr(new FatPtrExpr(array, offset), array, offset);
    }

    private SimpleExpr allocArray(int arrayLength) {
        if (this.valueFunction.getValueConstructor().isPresent()) {
            ArrayList valueConstructors = Lists.newArrayList();
            for (int i = 0; i < arrayLength; ++i) {
                valueConstructors.add(this.valueFunction.getValueConstructor().get());
            }
            return Expressions.newArray(this.valueFunction.getValueType(), valueConstructors);
        }
        return Expressions.newArray(this.valueFunction.getValueType(), arrayLength);
    }

    public Expr elementAt(Expr array, Expr index) {
        FatPtrExpr arrayFatPtr = (FatPtrExpr)array;
        SimpleExpr indexValue = (SimpleExpr)index;
        SimpleExpr newOffset = Expressions.sum(arrayFatPtr.getOffset(), Expressions.product(Expressions.difference(indexValue, this.arrayType.getLbound()), this.valueFunction.getElementLength()));
        return this.valueFunction.dereference(arrayFatPtr.getArray(), newOffset);
    }
}

