/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen.array;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.Expressions;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.expr.SimpleLValue;
import org.renjin.gcc.codegen.fatptr.FatPtrExpr;
import org.renjin.gcc.codegen.fatptr.FatPtrMalloc;
import org.renjin.gcc.codegen.fatptr.ValueFunction;
import org.renjin.gcc.codegen.fatptr.Wrappers;
import org.renjin.gcc.codegen.type.FieldStrategy;

public class ArrayField
extends FieldStrategy {
    private Type declaringClass;
    private String name;
    private int arrayLength;
    private final ValueFunction valueFunction;
    private final Type arrayType;

    public ArrayField(Type declaringClass, String name, int arrayLength, ValueFunction valueFunction) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.arrayLength = arrayLength;
        this.valueFunction = valueFunction;
        this.arrayType = Wrappers.valueArrayType(valueFunction.getValueType());
    }

    @Override
    public void writeFields(ClassVisitor cv) {
        cv.visitField(1, this.name, this.arrayType.getDescriptor(), null, null).visitEnd();
    }

    @Override
    public void emitInstanceInit(MethodGenerator mv) {
        SimpleExpr newArray = FatPtrMalloc.allocArray(mv, this.valueFunction, Expressions.constantInt(this.arrayLength));
        SimpleLValue arrayField = Expressions.field(Expressions.thisValue(this.declaringClass), this.arrayType, this.name);
        arrayField.store(mv, newArray);
    }

    @Override
    public Expr memberExprGenerator(SimpleExpr instance) {
        SimpleLValue array = Expressions.field(instance, this.arrayType, this.name);
        SimpleExpr offset = Expressions.zero();
        FatPtrExpr address = new FatPtrExpr(array, offset);
        return new FatPtrExpr(address, array, offset);
    }
}

