/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen;

import com.google.bc.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.Type;
import org.renjin.gcc.gimple.type.GimplePointerType;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;
import org.renjin.gcc.gimple.type.GimpleType;
import org.renjin.gcc.runtime.BooleanPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.FloatPtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.ShortPtr;

public class WrapperType {
    public static final WrapperType OBJECT_PTR = new WrapperType(ObjectPtr.class);
    private static final List<WrapperType> TYPES = ImmutableList.of((Object)new WrapperType(BytePtr.class), (Object)new WrapperType(IntPtr.class), (Object)new WrapperType(ShortPtr.class), (Object)new WrapperType(LongPtr.class), (Object)new WrapperType(BooleanPtr.class), (Object)new WrapperType(CharPtr.class), (Object)new WrapperType(DoublePtr.class), (Object)new WrapperType(FloatPtr.class), (Object)new WrapperType(ObjectPtr.class));
    private Type wrapperType;
    private final Type arrayType;
    private final Type baseType;

    public WrapperType(Class<? extends Ptr> wrapperClass) {
        try {
            Class<?> arrayClass = wrapperClass.getField("array").getType();
            this.wrapperType = Type.getType(wrapperClass);
            this.arrayType = Type.getType(arrayClass);
            this.baseType = Type.getType(arrayClass.getComponentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(wrapperClass.getName());
        }
    }

    public Type getWrapperType() {
        return this.wrapperType;
    }

    public Type getArrayType() {
        return this.arrayType;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public GimpleType getGimpleType() {
        return new GimplePointerType(GimplePrimitiveType.fromJvmType(this.baseType));
    }

    public static boolean is(Type type) {
        for (WrapperType wrapperType : TYPES) {
            if (!wrapperType.getWrapperType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public static boolean is(Class<?> aClass) {
        return WrapperType.is(Type.getType(aClass));
    }

    public static WrapperType valueOf(Type type) {
        for (WrapperType wrapperType : TYPES) {
            if (!wrapperType.getWrapperType().equals((Object)type)) continue;
            return wrapperType;
        }
        throw new IllegalArgumentException(type.toString());
    }

    public String toString() {
        return this.wrapperType.getInternalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapperType that = (WrapperType)o;
        return this.wrapperType.equals((Object)that.wrapperType);
    }

    public int hashCode() {
        return this.wrapperType.hashCode();
    }
}

