/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen;

import com.google.bc.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.FunctionGenerator;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.codegen.type.TypeStrategy;
import org.renjin.gcc.codegen.var.GlobalVarAllocator;
import org.renjin.gcc.codegen.var.ProvidedVarAllocator;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.symbols.GlobalSymbolTable;
import org.renjin.gcc.symbols.UnitSymbolTable;

public class UnitClassGenerator {
    private final GimpleCompilationUnit unit;
    private final String className;
    private final UnitSymbolTable symbolTable;
    private final TypeOracle typeOracle;
    private final GlobalVarAllocator globalVarAllocator;
    private final List<GimpleVarDecl> varToGenerate = Lists.newArrayList();
    private ClassWriter cw;
    private ClassVisitor cv;
    private StringWriter sw;
    private PrintWriter pw;

    public UnitClassGenerator(TypeOracle typeOracle, GlobalSymbolTable functionTable, Map<String, Field> providedVariables, GimpleCompilationUnit unit, String className) {
        this.unit = unit;
        this.className = className;
        this.typeOracle = typeOracle;
        this.globalVarAllocator = new GlobalVarAllocator(className);
        this.symbolTable = new UnitSymbolTable(functionTable, className);
        for (GimpleVarDecl decl : unit.getGlobalVariables()) {
            Object varGenerator;
            TypeStrategy typeStrategy = typeOracle.forType(decl.getType());
            if (this.isProvided(providedVariables, decl)) {
                Field providedField = providedVariables.get(decl.getName());
                varGenerator = typeStrategy.variable(decl, new ProvidedVarAllocator(providedField.getDeclaringClass()));
            } else {
                varGenerator = typeStrategy.variable(decl, this.globalVarAllocator);
                this.varToGenerate.add(decl);
            }
            this.symbolTable.addGlobalVariable(decl, (Expr)varGenerator);
        }
        for (GimpleFunction function : unit.getFunctions()) {
            try {
                this.symbolTable.addFunction(className, function, new FunctionGenerator(className, function, typeOracle, this.symbolTable));
            }
            catch (Exception e) {
                throw new InternalCompilerException(String.format("Exception creating %s for %s in %s: %s", FunctionGenerator.class.getSimpleName(), function.getName(), unit.getSourceName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    private boolean isProvided(Map<String, Field> providedVariables, GimpleVarDecl decl) {
        return decl.isExtern() && providedVariables.containsKey(decl.getName());
    }

    public String getClassName() {
        return this.className;
    }

    public void emit() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.cw = new ClassWriter(3);
        this.cv = GimpleCompiler.TRACE ? new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.out)) : this.cw;
        this.cv.visit(51, 33, this.className, null, "java/lang/Object", new String[0]);
        this.cv.visitSource(this.unit.getSourceName(), null);
        this.emitDefaultConstructor();
        this.emitGlobalVariables();
        this.emitFunctions(this.unit);
        this.cv.visitEnd();
    }

    private void emitDefaultConstructor() {
        MethodVisitor mv = this.cv.visitMethod(2, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void emitGlobalVariables() {
        this.globalVarAllocator.writeFields(this.cv);
        ExprFactory exprFactory = new ExprFactory(this.typeOracle, this.symbolTable, this.unit.getCallingConvention());
        MethodGenerator mv = new MethodGenerator(this.cv.visitMethod(8, "<clinit>", "()V", null, null));
        mv.visitCode();
        for (GimpleVarDecl decl : this.varToGenerate) {
            try {
                LValue varGenerator = (LValue)((Object)this.symbolTable.getGlobalVariable(decl));
                if (decl.getValue() == null) continue;
                varGenerator.store(mv, exprFactory.findGenerator(decl.getValue()));
            }
            catch (Exception e) {
                throw new InternalCompilerException("Exception writing static variable initializer " + decl.getName() + " defined in " + this.unit.getSourceFile().getName(), (Throwable)e);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void emitFunctions(GimpleCompilationUnit unit) {
        for (FunctionGenerator functionGenerator : this.symbolTable.getFunctions()) {
            try {
                functionGenerator.emit(this.cv);
            }
            catch (Exception e) {
                throw new InternalCompilerException(functionGenerator, e);
            }
        }
    }

    public byte[] toByteArray() {
        this.cv.visitEnd();
        return this.cw.toByteArray();
    }
}

