/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen;

import java.io.IOException;
import java.io.PrintWriter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceClassVisitor;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.codegen.FunctionGenerator;
import org.renjin.gcc.codegen.type.ParamStrategy;

public class TrampolineClassGenerator {
    private ClassWriter cw = new ClassWriter(3);
    private ClassVisitor cv = GimpleCompiler.TRACE ? new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.out)) : this.cw;

    public TrampolineClassGenerator(String className) {
        this.cv.visit(50, 33, className, null, "java/lang/Object", new String[0]);
        this.emitDefaultConstructor();
    }

    private void emitDefaultConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public void emitTrampolineMethod(FunctionGenerator functionGenerator) {
        MethodVisitor mv = this.cv.visitMethod(9, functionGenerator.getMangledName(), functionGenerator.getFunctionDescriptor(), null, null);
        mv.visitCode();
        int varIndex = 0;
        for (ParamStrategy generator : functionGenerator.getParamStrategies()) {
            for (Type type : generator.getParameterTypes()) {
                mv.visitVarInsn(type.getOpcode(21), varIndex);
                varIndex += type.getSize();
            }
        }
        mv.visitMethodInsn(184, functionGenerator.getClassName(), functionGenerator.getMangledName(), functionGenerator.getFunctionDescriptor(), false);
        Type returnType = functionGenerator.getReturnStrategy().getType();
        if (returnType.equals((Object)Type.VOID_TYPE)) {
            mv.visitInsn(177);
        } else {
            mv.visitInsn(returnType.getOpcode(172));
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public byte[] generateClassFile() throws IOException {
        this.cv.visitEnd();
        return this.cw.toByteArray();
    }
}

