/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen;

import com.google.bc.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceClassVisitor;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.type.FieldStrategy;

public class RecordClassGenerator {
    private ClassWriter cw;
    private ClassVisitor cv;
    private StringWriter sw;
    private PrintWriter pw;
    private Type className;
    private Collection<FieldStrategy> fields;

    public RecordClassGenerator(Type className, Collection<FieldStrategy> fields) {
        this.fields = fields;
        this.className = className;
    }

    public void writeClassFile(File outputDirectory) throws IOException {
        boolean created;
        File classFile = new File(outputDirectory.getAbsolutePath() + File.separator + this.className.getInternalName() + ".class");
        if (!classFile.getParentFile().exists() && !(created = classFile.getParentFile().mkdirs())) {
            throw new IOException("Failed to create directory for class file: " + classFile.getParentFile());
        }
        Files.write((byte[])this.generateClassFile(), (File)classFile);
    }

    public byte[] generateClassFile() throws IOException {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.cw = new ClassWriter(3);
        this.cv = GimpleCompiler.TRACE ? new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.out)) : this.cw;
        this.cv.visit(50, 33, this.className.getInternalName(), null, "java/lang/Object", new String[0]);
        this.emitDefaultConstructor();
        this.emitFields();
        this.cv.visitEnd();
        return this.cw.toByteArray();
    }

    private void emitFields() {
        for (FieldStrategy fieldStrategy : this.fields) {
            fieldStrategy.writeFields(this.cv);
        }
    }

    private void emitDefaultConstructor() {
        MethodGenerator mv = new MethodGenerator(this.cv.visitMethod(1, "<init>", "()V", null, null));
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        for (FieldStrategy fieldStrategy : this.fields) {
            fieldStrategy.emitInstanceInit(mv);
        }
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }
}

