/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.codegen;

import com.google.bc.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.codegen.Labels;
import org.renjin.gcc.codegen.MethodGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.call.InvocationStrategy;
import org.renjin.gcc.codegen.condition.ConditionGenerator;
import org.renjin.gcc.codegen.expr.Expr;
import org.renjin.gcc.codegen.expr.ExprFactory;
import org.renjin.gcc.codegen.expr.LValue;
import org.renjin.gcc.codegen.expr.SimpleExpr;
import org.renjin.gcc.codegen.type.ParamStrategy;
import org.renjin.gcc.codegen.type.ReturnStrategy;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.codegen.type.TypeStrategy;
import org.renjin.gcc.codegen.var.LocalVarAllocator;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.statement.GimpleAssignment;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleConditional;
import org.renjin.gcc.gimple.statement.GimpleGoto;
import org.renjin.gcc.gimple.statement.GimpleReturn;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.statement.GimpleSwitch;
import org.renjin.gcc.gimple.type.GimpleVoidType;
import org.renjin.gcc.peephole.PeepholeOptimizer;
import org.renjin.gcc.symbols.LocalVariableTable;
import org.renjin.gcc.symbols.UnitSymbolTable;

public class FunctionGenerator
implements InvocationStrategy {
    private String className;
    private GimpleFunction function;
    private Map<GimpleParameter, ParamStrategy> params = Maps.newHashMap();
    private ReturnStrategy returnStrategy;
    private Labels labels = new Labels();
    private TypeOracle typeOracle;
    private ExprFactory exprFactory;
    private LocalVariableTable symbolTable;
    private Label beginLabel = new Label();
    private Label endLabel = new Label();
    private MethodGenerator mv;

    public FunctionGenerator(String className, GimpleFunction function, TypeOracle typeOracle, UnitSymbolTable symbolTable) {
        this.className = className;
        this.function = function;
        this.typeOracle = typeOracle;
        this.params = this.typeOracle.forParameters(function.getParameters());
        this.returnStrategy = this.typeOracle.returnStrategyFor(function.getReturnType());
        this.symbolTable = new LocalVariableTable(symbolTable);
        this.exprFactory = new ExprFactory(typeOracle, this.symbolTable, function.getCallingConvention());
    }

    public String getMangledName() {
        return this.function.getMangledName();
    }

    public GimpleFunction getFunction() {
        return this.function;
    }

    public void emit(ClassVisitor cw) {
        if (GimpleCompiler.TRACE) {
            System.out.println(this.function);
        }
        MethodNode methodNode = new MethodNode(9, this.function.getMangledName(), this.getFunctionDescriptor(), null, null);
        this.mv = new MethodGenerator((MethodVisitor)methodNode);
        this.mv.visitCode();
        this.mv.visitLabel(this.beginLabel);
        this.emitParamInitialization();
        this.scheduleLocalVariables();
        this.emitLocalVarInitialization();
        for (GimpleBasicBlock basicBlock : this.function.getBasicBlocks()) {
            this.emitBasicBlock(basicBlock);
        }
        GimpleBasicBlock lastBlock = this.function.getLastBasicBlock();
        if (lastBlock.fallsThrough()) {
            SimpleExpr defaultReturnValue = this.returnStrategy.getDefaultReturnValue();
            defaultReturnValue.load(this.mv);
            this.mv.areturn(defaultReturnValue.getType());
        }
        this.mv.visitLabel(this.endLabel);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
        PeepholeOptimizer.INSTANCE.optimize(methodNode);
        try {
            methodNode.accept(cw);
        }
        catch (Exception e) {
            throw new InternalCompilerException("Error in generated byte code for " + this.function.getName() + "\n" + "Offending bytecode:\n" + this.toString(methodNode), (Throwable)e);
        }
    }

    private String toString(MethodNode methodNode) {
        try {
            Textifier p = new Textifier();
            methodNode.accept((MethodVisitor)new TraceMethodVisitor((Printer)p));
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                p.print(pw);
            }
            return sw.toString();
        }
        catch (Exception e) {
            return "<Exception generating bytecode: " + e.getClass().getName() + ": " + e.getMessage() + ">";
        }
    }

    private void emitParamInitialization() {
        int i;
        int numParameters = this.function.getParameters().size();
        ArrayList paramIndexes = new ArrayList();
        for (i = 0; i < numParameters; ++i) {
            ArrayList<LocalVarAllocator.LocalVar> paramVars = new ArrayList<LocalVarAllocator.LocalVar>();
            GimpleParameter param = this.function.getParameters().get(i);
            ParamStrategy paramStrategy = this.params.get(param);
            List<Type> parameterTypes = paramStrategy.getParameterTypes();
            if (parameterTypes.size() == 1) {
                paramVars.add(this.mv.getLocalVarAllocator().reserve(param.getName(), parameterTypes.get(0)));
            } else {
                for (int typeIndex = 0; typeIndex < parameterTypes.size(); ++typeIndex) {
                    paramVars.add(this.mv.getLocalVarAllocator().reserve(param.getName() + "$" + typeIndex, parameterTypes.get(typeIndex)));
                }
            }
            paramIndexes.add(paramVars);
        }
        for (i = 0; i < numParameters; ++i) {
            GimpleParameter param = this.function.getParameters().get(i);
            ParamStrategy generator = this.params.get(param);
            Expr expr = generator.emitInitialization(this.mv, param, (List)paramIndexes.get(i), this.mv.getLocalVarAllocator());
            this.symbolTable.addVariable(param.getId(), expr);
        }
    }

    private void emitLocalVarInitialization() {
        this.mv.getLocalVarAllocator().initializeVariables(this.mv);
        for (GimpleVarDecl decl : this.function.getVariableDeclarations()) {
            LValue lhs = (LValue)((Object)this.symbolTable.getVariable(decl));
            if (decl.getValue() == null) continue;
            lhs.store(this.mv, this.exprFactory.findGenerator(decl.getValue()));
        }
    }

    private void scheduleLocalVariables() {
        for (GimpleVarDecl varDecl : this.function.getVariableDeclarations()) {
            try {
                TypeStrategy factory = this.typeOracle.forType(varDecl.getType());
                Object generator = factory.variable(varDecl, this.mv.getLocalVarAllocator());
                this.symbolTable.addVariable(varDecl.getId(), (Expr)generator);
            }
            catch (Exception e) {
                throw new InternalCompilerException("Exception generating local variable " + varDecl, (Throwable)e);
            }
        }
    }

    private void emitBasicBlock(GimpleBasicBlock basicBlock) {
        this.mv.visitLabel(this.labels.of(basicBlock));
        for (GimpleStatement ins : basicBlock.getStatements()) {
            Label insLabel;
            block9: {
                insLabel = new Label();
                this.mv.visitLabel(insLabel);
                try {
                    if (ins instanceof GimpleAssignment) {
                        this.emitAssignment((GimpleAssignment)ins);
                        break block9;
                    }
                    if (ins instanceof GimpleReturn) {
                        this.emitReturn((GimpleReturn)ins);
                        break block9;
                    }
                    if (ins instanceof GimpleGoto) {
                        this.emitGoto((GimpleGoto)ins);
                        break block9;
                    }
                    if (ins instanceof GimpleConditional) {
                        this.emitConditional((GimpleConditional)ins);
                        break block9;
                    }
                    if (ins instanceof GimpleCall) {
                        this.emitCall((GimpleCall)ins);
                        break block9;
                    }
                    if (ins instanceof GimpleSwitch) {
                        this.emitSwitch((GimpleSwitch)ins);
                        break block9;
                    }
                    throw new UnsupportedOperationException("ins: " + ins);
                }
                catch (Exception e) {
                    throw new InternalCompilerException("Exception compiling instruction " + ins, (Throwable)e);
                }
            }
            if (ins.getLineNumber() == null) continue;
            this.mv.visitLineNumber(ins.getLineNumber(), insLabel);
        }
    }

    private void emitSwitch(GimpleSwitch ins) {
        SimpleExpr valueGenerator = this.exprFactory.findValueGenerator(ins.getValue());
        valueGenerator.load(this.mv);
        Label defaultLabel = this.labels.of(ins.getDefaultCase().getBasicBlockIndex());
        int numCases = ins.getCaseCount();
        Label[] caseLabels = new Label[numCases];
        int[] caseValues = new int[numCases];
        int i = 0;
        for (GimpleSwitch.Case aCase : ins.getCases()) {
            int value = aCase.getLow();
            while (value <= aCase.getHigh()) {
                caseLabels[i] = this.labels.of(aCase.getBasicBlockIndex());
                caseValues[i] = value++;
                ++i;
            }
        }
        this.mv.visitLookupSwitchInsn(defaultLabel, caseValues, caseLabels);
    }

    private void emitAssignment(GimpleAssignment ins) {
        try {
            Expr lhs = this.exprFactory.findGenerator(ins.getLHS());
            Expr rhs = this.exprFactory.findGenerator(ins.getOperator(), ins.getOperands(), ins.getLHS().getType());
            if (!(lhs instanceof LValue)) {
                throw new InternalCompilerException(ins.getLHS() + " is not an LHS expression: " + lhs.getClass().getName());
            }
            ((LValue)((Object)lhs)).store(this.mv, rhs);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception compiling assignment " + ins, e);
        }
    }

    private void emitGoto(GimpleGoto ins) {
        this.mv.visitJumpInsn(167, this.labels.of(ins.getTarget()));
    }

    private void emitConditional(GimpleConditional ins) {
        ConditionGenerator generator = this.exprFactory.findConditionGenerator(ins.getOperator(), ins.getOperands());
        generator.emitJump(this.mv, this.labels.of(ins.getTrueLabel()), this.labels.of(ins.getFalseLabel()));
    }

    private void emitCall(GimpleCall ins) {
        CallGenerator callGenerator = this.exprFactory.findCallGenerator(ins.getFunction(), ins.getOperands());
        callGenerator.emitCall(this.mv, this.exprFactory, ins);
    }

    private void emitReturn(GimpleReturn ins) {
        if (this.function.getReturnType() instanceof GimpleVoidType) {
            this.mv.areturn(Type.VOID_TYPE);
        } else {
            SimpleExpr returnValue;
            if (ins.getValue() == null) {
                returnValue = this.returnStrategy.getDefaultReturnValue();
            } else {
                Expr returnExpr = this.exprFactory.findGenerator(ins.getValue(), this.function.getReturnType());
                returnValue = this.returnStrategy.marshall(returnExpr);
            }
            returnValue.load(this.mv);
            this.mv.areturn(returnValue.getType());
        }
    }

    public String getFunctionDescriptor() {
        return TypeOracle.getMethodDescriptor(this.returnStrategy, this.getParamStrategies());
    }

    @Override
    public List<ParamStrategy> getParamStrategies() {
        ArrayList<ParamStrategy> parameterTypes = new ArrayList<ParamStrategy>();
        for (GimpleParameter parameter : this.function.getParameters()) {
            ParamStrategy generator = this.params.get(parameter);
            parameterTypes.add(generator);
        }
        return parameterTypes;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    public Type returnType() {
        return this.returnStrategy.getType();
    }

    @Override
    public ReturnStrategy getReturnStrategy() {
        return this.returnStrategy;
    }

    @Override
    public void invoke(MethodGenerator mv) {
        mv.invokestatic(this.getClassName(), this.getMangledName(), this.getFunctionDescriptor(), false);
    }

    public GimpleCompilationUnit getCompilationUnit() {
        return this.function.getUnit();
    }

    @Override
    public Handle getMethodHandle() {
        return new Handle(6, this.className, this.function.getMangledName(), this.getFunctionDescriptor());
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return this.className + "." + this.getMangledName() + "()";
    }
}

