/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.collect.Sets;
import java.util.Set;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.analysis.FunctionBodyTransformer;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.GimpleVisitor;
import org.renjin.gcc.gimple.expr.GimpleConstant;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleVariableRef;
import org.renjin.gcc.gimple.statement.GimpleAssignment;
import org.renjin.gcc.gimple.statement.GimpleConditional;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.type.GimplePointerType;
import org.renjin.gcc.gimple.type.GimpleType;
import org.renjin.gcc.gimple.type.GimpleVoidType;

public class VoidPointerTypeDeducer
implements FunctionBodyTransformer {
    public static final VoidPointerTypeDeducer INSTANCE = new VoidPointerTypeDeducer();

    private VoidPointerTypeDeducer() {
    }

    @Override
    public boolean transform(GimpleCompilationUnit unit, GimpleFunction fn) {
        boolean updated = false;
        for (GimpleVarDecl decl : fn.getVariableDeclarations()) {
            if (!this.isVoidPtr(decl.getType())) continue;
            if (GimpleCompiler.TRACE) {
                System.out.println("Deducing type of " + decl + "...");
            }
            if (!this.tryToDeduceType(unit, fn, decl)) continue;
            updated = true;
        }
        return updated;
    }

    private boolean isVoidPtr(GimpleType type) {
        return type instanceof GimplePointerType && type.getBaseType() instanceof GimpleVoidType;
    }

    private boolean tryToDeduceType(GimpleCompilationUnit unit, GimpleFunction fn, GimpleVarDecl decl) {
        AssignmentFinder finder = new AssignmentFinder(unit, fn, decl);
        fn.visitIns(finder);
        if (finder.possibleTypes.size() == 1) {
            GimpleType deducedType = (GimpleType)finder.possibleTypes.iterator().next();
            if (GimpleCompiler.TRACE) {
                System.out.println("...resolved to " + deducedType);
            }
            decl.setType(deducedType);
            this.updateVarRefTypes(fn, decl);
            this.updatePointerComparisons(fn, decl);
            return true;
        }
        return false;
    }

    private void updateVarRefTypes(GimpleFunction fn, GimpleVarDecl decl) {
        fn.replaceAll(decl.isReference(), new GimpleVariableRef(decl.getId(), decl.getType()));
    }

    private void updatePointerComparisons(GimpleFunction fn, GimpleVarDecl decl) {
        GimpleVariableRef ref = decl.newRef();
        for (GimpleBasicBlock basicBlock : fn.getBasicBlocks()) {
            for (GimpleStatement statement : basicBlock.getStatements()) {
                GimpleConditional conditional;
                if (!(statement instanceof GimpleConditional) || (conditional = (GimpleConditional)statement).getOperator() != GimpleOp.NE_EXPR && conditional.getOperator() != GimpleOp.EQ_EXPR) continue;
                if (conditional.getOperand(0).equals(ref) && this.isNull(conditional.getOperand(1))) {
                    conditional.getOperand(1).setType(decl.getType());
                    continue;
                }
                if (!conditional.getOperand(1).equals(ref) || !this.isNull(conditional.getOperand(0))) continue;
                conditional.getOperand(0).setType(decl.getType());
            }
        }
    }

    private boolean isNull(GimpleExpr operand) {
        return operand instanceof GimpleConstant && ((GimpleConstant)operand).isNull();
    }

    private class AssignmentFinder
    extends GimpleVisitor {
        private final GimpleCompilationUnit unit;
        private final GimpleFunction fn;
        private final GimpleVarDecl decl;
        private final Set<GimpleType> possibleTypes = Sets.newHashSet();

        public AssignmentFinder(GimpleCompilationUnit unit, GimpleFunction fn, GimpleVarDecl decl) {
            this.unit = unit;
            this.fn = fn;
            this.decl = decl;
        }

        @Override
        public void visitAssignment(GimpleAssignment assignment) {
            switch (assignment.getOperator()) {
                case VAR_DECL: 
                case NOP_EXPR: {
                    GimpleExpr rhs = assignment.getOperands().get(0);
                    if (this.isReference(rhs)) {
                        this.inferPossibleTypes(assignment.getLHS());
                        break;
                    }
                    if (!this.isReference(assignment.getLHS())) break;
                    this.inferPossibleTypes(rhs);
                }
            }
        }

        private void inferPossibleTypes(GimpleExpr expr) {
            if (expr.getType() != null && !VoidPointerTypeDeducer.this.isVoidPtr(expr.getType())) {
                this.possibleTypes.add(expr.getType());
            }
        }

        private boolean isReference(GimpleExpr expr) {
            return expr instanceof GimpleVariableRef && ((GimpleVariableRef)expr).getId() == this.decl.getId();
        }
    }
}

