/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.annotations.VisibleForTesting;
import com.google.bc.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.gcc.analysis.Malloc;
import org.renjin.gcc.codegen.type.record.RecordClassTypeStrategy;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleIntegerConstant;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.type.GimpleArrayType;
import org.renjin.gcc.gimple.type.GimpleField;
import org.renjin.gcc.gimple.type.GimplePointerType;
import org.renjin.gcc.gimple.type.GimpleRecordType;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;
import org.renjin.gcc.gimple.type.GimpleType;

public class RecordUsageAnalyzer {
    private Map<String, GimpleRecordTypeDef> map = Maps.newHashMap();
    @VisibleForTesting
    Set<String> unitPointerAssumptionsHold = new HashSet<String>();

    public RecordUsageAnalyzer(Collection<GimpleRecordTypeDef> recordTypeDefs) {
        for (GimpleRecordTypeDef recordTypeDef : recordTypeDefs) {
            this.map.put(recordTypeDef.getId(), recordTypeDef);
        }
    }

    public void analyze(List<GimpleCompilationUnit> units) {
        this.checkUnitRecordPtrAssumptions(units);
    }

    private void checkUnitRecordPtrAssumptions(List<GimpleCompilationUnit> units) {
        this.unitPointerAssumptionsHold.addAll(this.map.keySet());
        this.checkForArrayDeclarations(units);
        this.checkForRecordMallocs(units);
    }

    private void checkForArrayDeclarations(List<GimpleCompilationUnit> units) {
        for (GimpleRecordTypeDef recordTypeDef : this.map.values()) {
            for (GimpleField gimpleField : recordTypeDef.getFields()) {
                this.checkForRecordArray(gimpleField.getType());
            }
        }
        for (GimpleCompilationUnit unit : units) {
            for (GimpleVarDecl gimpleVarDecl : unit.getGlobalVariables()) {
                this.checkForRecordArray(gimpleVarDecl.getType());
            }
            for (GimpleFunction function : unit.getFunctions()) {
                for (GimpleVarDecl gimpleVarDecl : function.getVariableDeclarations()) {
                    this.checkForRecordArray(gimpleVarDecl.getType());
                }
            }
        }
    }

    private void checkForRecordArray(GimpleType type) {
        GimpleType componentType;
        if (type instanceof GimpleArrayType && (componentType = ((GimpleArrayType)type).getComponentType()) instanceof GimpleRecordType) {
            GimpleRecordType recordType = (GimpleRecordType)componentType;
            this.unitPointerAssumptionsHold.remove(recordType.getId());
        }
    }

    private void checkForRecordMallocs(List<GimpleCompilationUnit> units) {
        for (GimpleCompilationUnit unit : units) {
            for (GimpleFunction function : unit.getFunctions()) {
                for (GimpleBasicBlock basicBlock : function.getBasicBlocks()) {
                    for (GimpleStatement statement : basicBlock.getStatements()) {
                        GimpleCall call;
                        if (!(statement instanceof GimpleCall) || !Malloc.isMalloc((call = (GimpleCall)statement).getFunction())) continue;
                        this.checkForRecordMalloc(call);
                    }
                }
            }
        }
    }

    private void checkForRecordMalloc(GimpleCall mallocCall) {
        GimpleType pointerType = mallocCall.getLhs().getType();
        assert (pointerType instanceof GimplePointerType) : "Malloc must be assigned to a pointer";
        if (pointerType.getBaseType() instanceof GimpleRecordType) {
            GimpleRecordType recordType = (GimpleRecordType)pointerType.getBaseType();
            GimpleExpr size = mallocCall.getOperands().get(0);
            if (!this.staticallyEqual(size, recordType.sizeOf())) {
                this.unitPointerAssumptionsHold.remove(recordType.getId());
            }
        }
    }

    private boolean staticallyEqual(GimpleExpr expr, int value) {
        if (expr instanceof GimpleIntegerConstant) {
            GimpleIntegerConstant constant = (GimpleIntegerConstant)expr;
            return constant.getNumberValue().intValue() == value;
        }
        return false;
    }

    public RecordClassTypeStrategy getStrategyFor(GimpleRecordTypeDef recordTypeDef) {
        RecordClassTypeStrategy strategy = new RecordClassTypeStrategy(recordTypeDef);
        strategy.setUnitPointer(this.unitPointerAssumptionsHold.contains(recordTypeDef.getId()));
        return strategy;
    }
}

