/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleAddressOf;
import org.renjin.gcc.gimple.expr.GimpleArrayRef;
import org.renjin.gcc.gimple.expr.GimpleComponentRef;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleMemRef;
import org.renjin.gcc.gimple.expr.GimpleNopExpr;
import org.renjin.gcc.gimple.statement.GimpleAssignment;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleConditional;
import org.renjin.gcc.gimple.statement.GimpleReturn;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.statement.GimpleSwitch;
import org.renjin.gcc.gimple.type.GimpleArrayType;
import org.renjin.gcc.gimple.type.GimpleBooleanType;
import org.renjin.gcc.gimple.type.GimpleComplexType;
import org.renjin.gcc.gimple.type.GimpleField;
import org.renjin.gcc.gimple.type.GimpleFunctionType;
import org.renjin.gcc.gimple.type.GimpleIndirectType;
import org.renjin.gcc.gimple.type.GimpleIntegerType;
import org.renjin.gcc.gimple.type.GimpleRealType;
import org.renjin.gcc.gimple.type.GimpleRecordType;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;
import org.renjin.gcc.gimple.type.GimpleType;
import org.renjin.gcc.gimple.type.GimpleVoidType;

public class RecordTypeDefCanonicalizer {
    private Map<String, GimpleRecordTypeDef> idMap = Maps.newHashMap();
    private Map<String, GimpleRecordTypeDef> idToCanonicalMap = Maps.newHashMap();
    private List<GimpleRecordTypeDef> canonical = Lists.newArrayList();

    public static Collection<GimpleRecordTypeDef> canonicalize(List<GimpleCompilationUnit> units) {
        RecordTypeDefCanonicalizer transformer = new RecordTypeDefCanonicalizer(units);
        transformer.updateAllTypes(units);
        return transformer.canonical;
    }

    private RecordTypeDefCanonicalizer(List<GimpleCompilationUnit> units) {
        boolean changing;
        ArrayList distinct = Lists.newArrayList();
        for (GimpleCompilationUnit unit : units) {
            distinct.addAll(unit.getRecordTypes());
        }
        do {
            changing = false;
            HashMap<String, GimpleRecordTypeDef> keyMap = new HashMap<String, GimpleRecordTypeDef>();
            for (GimpleRecordTypeDef recordTypeDef : distinct) {
                String key = this.key(recordTypeDef);
                GimpleRecordTypeDef canonical = (GimpleRecordTypeDef)keyMap.get(key);
                if (canonical == null) {
                    keyMap.put(key, recordTypeDef);
                    continue;
                }
                this.idToCanonicalMap.put(recordTypeDef.getId(), canonical);
                changing = true;
            }
            distinct = Lists.newArrayList(keyMap.values());
            for (GimpleRecordTypeDef recordTypeDef : distinct) {
                this.updateFieldTypes(recordTypeDef);
            }
        } while (changing);
        this.canonical = distinct;
    }

    private String key(GimpleRecordTypeDef typeDef) {
        StringBuilder key = new StringBuilder();
        if (typeDef.getName() != null) {
            key.append(typeDef.getName());
        }
        this.appendKeyTo(typeDef, key);
        return key.toString();
    }

    public void appendKeyTo(GimpleRecordTypeDef def, StringBuilder key) {
        key.append("{");
        boolean needsComma = false;
        for (GimpleField gimpleField : def.getFields()) {
            if (needsComma) {
                key.append(",");
            }
            key.append(gimpleField.getName()).append(":");
            this.appendTypeKeyTo(def, gimpleField.getType(), key);
            needsComma = true;
        }
        key.append("}");
    }

    private void appendTypeKeyTo(GimpleRecordTypeDef rootRecordTypeDef, GimpleType type, StringBuilder key) {
        if (type instanceof GimpleRecordType) {
            GimpleRecordType recordType = (GimpleRecordType)type;
            if (recordType.getId().equals(rootRecordTypeDef.getId())) {
                key.append("recursive");
            } else {
                key.append("record(").append(recordType.getId()).append(")");
            }
        } else if (type instanceof GimpleIndirectType) {
            key.append("*");
            this.appendTypeKeyTo(rootRecordTypeDef, (GimpleType)type.getBaseType(), key);
        } else if (type instanceof GimpleArrayType) {
            key.append("[");
            this.appendTypeKeyTo(rootRecordTypeDef, ((GimpleArrayType)type).getComponentType(), key);
        } else if (type instanceof GimpleComplexType) {
            key.append("complex");
        } else if (type instanceof GimpleRealType) {
            key.append("real").append(((GimpleRealType)type).getPrecision());
        } else if (type instanceof GimpleIntegerType) {
            key.append("int").append(((GimpleIntegerType)type).getPrecision());
        } else if (type instanceof GimpleFunctionType) {
            key.append("fun");
        } else if (type instanceof GimpleBooleanType) {
            key.append("bool");
        } else if (type instanceof GimpleVoidType) {
            key.append("void");
        }
    }

    public GimpleRecordTypeDef resolve(GimpleRecordType recordType) {
        GimpleRecordTypeDef canonicalDef = this.idToCanonicalMap.get(recordType.getId());
        if (canonicalDef == null) {
            throw new IllegalArgumentException("No such record: " + recordType.getId());
        }
        return canonicalDef;
    }

    private void updateAllTypes(List<GimpleCompilationUnit> units) {
        for (GimpleRecordTypeDef recordTypeDef : this.idToCanonicalMap.values()) {
            this.updateFieldTypes(recordTypeDef);
        }
        for (GimpleCompilationUnit unit : units) {
            for (int i = 0; i < unit.getRecordTypes().size(); ++i) {
                GimpleRecordTypeDef recordTypeDef = unit.getRecordTypes().get(i);
                GimpleRecordTypeDef canonicalDef = this.idToCanonicalMap.get(recordTypeDef.getId());
                if (canonicalDef == null) continue;
                unit.getRecordTypes().set(i, canonicalDef);
            }
            for (GimpleVarDecl decl : unit.getGlobalVariables()) {
                this.updateType(decl.getType());
            }
            for (GimpleFunction function : unit.getFunctions()) {
                this.updateType(function.getReturnType());
                for (GimpleParameter gimpleParameter : function.getParameters()) {
                    this.updateType(gimpleParameter.getType());
                }
                for (GimpleVarDecl decl : function.getVariableDeclarations()) {
                    this.updateType(decl.getType());
                }
                for (GimpleBasicBlock basicBlock : function.getBasicBlocks()) {
                    for (GimpleStatement statement : basicBlock.getStatements()) {
                        this.updateTypes(statement);
                    }
                }
            }
        }
    }

    private void updateFieldTypes(GimpleRecordTypeDef recordTypeDef) {
        for (GimpleField gimpleField : recordTypeDef.getFields()) {
            this.updateType(gimpleField.getType());
        }
    }

    private void updateTypes(Iterable<GimpleType> types) {
        for (GimpleType type : types) {
            this.updateType(type);
        }
    }

    private void updateType(GimpleType type) {
        if (type instanceof GimpleRecordType) {
            GimpleRecordType recordType = (GimpleRecordType)type;
            GimpleRecordTypeDef canonicalDef = this.idToCanonicalMap.get(recordType.getId());
            if (canonicalDef != null) {
                recordType.setId(canonicalDef.getId());
            }
        } else if (type instanceof GimpleIndirectType) {
            this.updateType((GimpleType)type.getBaseType());
        } else if (type instanceof GimpleArrayType) {
            this.updateType(((GimpleArrayType)type).getComponentType());
        } else if (type instanceof GimpleFunctionType) {
            GimpleFunctionType functionType = (GimpleFunctionType)type;
            this.updateType(functionType.getReturnType());
            this.updateTypes((Iterable<GimpleType>)functionType.getArgumentTypes());
        }
    }

    private void updateTypes(GimpleStatement gimpleIns) {
        if (gimpleIns instanceof GimpleReturn) {
            this.updateTypes(((GimpleReturn)gimpleIns).getValue());
        } else if (gimpleIns instanceof GimpleAssignment) {
            GimpleAssignment assignment = (GimpleAssignment)gimpleIns;
            this.updateTypes(assignment.getLHS());
            this.updateTypes(assignment.getOperands());
        } else if (gimpleIns instanceof GimpleCall) {
            GimpleCall call = (GimpleCall)gimpleIns;
            this.updateTypes(call.getLhs());
            this.updateTypes(call.getOperands());
        } else if (gimpleIns instanceof GimpleConditional) {
            GimpleConditional conditional = (GimpleConditional)gimpleIns;
            this.updateTypes(conditional.getOperands());
        } else if (gimpleIns instanceof GimpleSwitch) {
            GimpleSwitch gimpleSwitch = (GimpleSwitch)gimpleIns;
            this.updateTypes(gimpleSwitch.getValue());
        }
    }

    private void updateTypes(List<GimpleExpr> operands) {
        for (GimpleExpr operand : operands) {
            this.updateTypes(operand);
        }
    }

    private void updateTypes(GimpleExpr expr) {
        if (expr != null) {
            this.updateType(expr.getType());
            if (expr instanceof GimpleAddressOf) {
                this.updateTypes(((GimpleAddressOf)expr).getValue());
            } else if (expr instanceof GimpleMemRef) {
                this.updateTypes(((GimpleMemRef)expr).getPointer());
            } else if (expr instanceof GimpleComponentRef) {
                this.updateTypes(((GimpleComponentRef)expr).getValue());
            } else if (expr instanceof GimpleArrayRef) {
                this.updateTypes(((GimpleArrayRef)expr).getArray());
            } else if (expr instanceof GimpleNopExpr) {
                this.updateTypes(((GimpleNopExpr)expr).getValue());
            }
        }
    }
}

