/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import java.util.Set;
import org.renjin.gcc.GimpleCompiler;
import org.renjin.gcc.analysis.ControlFlowGraph;
import org.renjin.gcc.analysis.FunctionBodyTransformer;
import org.renjin.gcc.analysis.InitDataFlowAnalysis;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleComplexConstant;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleIntegerConstant;
import org.renjin.gcc.gimple.expr.GimpleRealConstant;
import org.renjin.gcc.gimple.type.GimpleBooleanType;
import org.renjin.gcc.gimple.type.GimpleComplexType;
import org.renjin.gcc.gimple.type.GimpleIndirectType;
import org.renjin.gcc.gimple.type.GimpleIntegerType;
import org.renjin.gcc.gimple.type.GimpleRealType;
import org.renjin.gcc.gimple.type.GimpleType;

public class LocalVariableInitializer
implements FunctionBodyTransformer {
    public static final LocalVariableInitializer INSTANCE = new LocalVariableInitializer();

    @Override
    public boolean transform(GimpleCompilationUnit unit, GimpleFunction fn) {
        ControlFlowGraph cfg = new ControlFlowGraph(fn);
        InitDataFlowAnalysis flowAnalysis = new InitDataFlowAnalysis(fn, cfg);
        flowAnalysis.solve();
        if (GimpleCompiler.TRACE) {
            flowAnalysis.dump();
        }
        Set<GimpleVarDecl> toInitialize = flowAnalysis.getVariablesUsedWithoutInitialization();
        for (GimpleVarDecl decl : toInitialize) {
            GimpleExpr defaultValue = this.defaultValue(decl.getType());
            decl.setValue(defaultValue);
            if (!GimpleCompiler.TRACE) continue;
            System.out.println("INITIALIZING " + decl + " = " + defaultValue);
        }
        return false;
    }

    private GimpleExpr defaultValue(GimpleType type) {
        if (type instanceof GimpleIntegerType) {
            return new GimpleIntegerConstant((GimpleIntegerType)type, 0L);
        }
        if (type instanceof GimpleRealType) {
            return new GimpleRealConstant((GimpleRealType)type, 0.0);
        }
        if (type instanceof GimpleIndirectType) {
            return GimpleIntegerConstant.nullValue((GimpleIndirectType)type);
        }
        if (type instanceof GimpleBooleanType) {
            GimpleIntegerConstant defaultValue = new GimpleIntegerConstant();
            defaultValue.setValue(0L);
            defaultValue.setType(type);
            return defaultValue;
        }
        if (type instanceof GimpleComplexType) {
            GimpleComplexConstant zero = new GimpleComplexConstant();
            GimpleRealType partType = ((GimpleComplexType)type).getPartType();
            zero.setType(type);
            zero.setIm(new GimpleRealConstant(partType, 0.0));
            zero.setReal(new GimpleRealConstant(partType, 0.0));
            return zero;
        }
        throw new UnsupportedOperationException("Don't know how to create default value for " + type);
    }
}

