/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.base.Optional;
import com.google.bc.common.collect.Maps;
import com.google.bc.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.renjin.gcc.analysis.ControlFlowGraph;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleAddressOf;
import org.renjin.gcc.gimple.expr.GimpleComponentRef;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleMemRef;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.gimple.expr.GimpleVariableRef;
import org.renjin.gcc.gimple.statement.GimpleAssignment;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.type.GimpleArrayType;
import org.renjin.gcc.gimple.type.GimpleRecordType;

public class InitDataFlowAnalysis {
    private ControlFlowGraph cfg;
    private Map<Integer, GimpleVarDecl> localVariables = Maps.newHashMap();
    private Map<ControlFlowGraph.Node, Set<Integer>> entryState = new HashMap<ControlFlowGraph.Node, Set<Integer>>();
    private Map<ControlFlowGraph.Node, Set<Integer>> exitState = new HashMap<ControlFlowGraph.Node, Set<Integer>>();

    public InitDataFlowAnalysis(GimpleFunction function, ControlFlowGraph cfg) {
        this.cfg = cfg;
        for (GimpleVarDecl decl : function.getVariableDeclarations()) {
            this.localVariables.put(decl.getId(), decl);
        }
    }

    public void solve() {
        boolean changed;
        HashSet<Integer> initialState = new HashSet<Integer>();
        for (GimpleVarDecl decl : this.localVariables.values()) {
            if (decl.getValue() != null) {
                initialState.add(decl.getId());
            }
            if (!(decl.getType() instanceof GimpleArrayType) && !(decl.getType() instanceof GimpleRecordType)) continue;
            initialState.add(decl.getId());
        }
        for (ControlFlowGraph.Node node : this.cfg.getNodes()) {
            this.entryState.put(node, initialState);
            this.exitState.put(node, this.applyTransfer(initialState, node.getBasicBlock()));
        }
        do {
            changed = false;
            for (ControlFlowGraph.Node node : this.cfg.getBasicBlockNodes()) {
                Set<Integer> updatedExitState;
                Set<Integer> currentEntryState = this.entryState.get(node);
                Set<Integer> updatedEntryState = this.applyJoin(node);
                if (updatedEntryState.equals(currentEntryState)) continue;
                this.entryState.put(node, updatedEntryState);
                Set<Integer> currentExitState = this.exitState.get(node);
                if (currentExitState.equals(updatedExitState = this.applyTransfer(updatedEntryState, node.getBasicBlock()))) continue;
                changed = true;
                this.exitState.put(node, updatedExitState);
            }
        } while (changed);
    }

    public Set<GimpleVarDecl> getVariablesUsedWithoutInitialization() {
        HashSet<GimpleVarDecl> result = new HashSet<GimpleVarDecl>();
        for (ControlFlowGraph.Node node : this.cfg.getBasicBlockNodes()) {
            HashSet<Integer> initialized = new HashSet<Integer>((Collection)this.entryState.get(node));
            for (GimpleStatement statement : node.getBasicBlock().getStatements()) {
                for (GimpleSymbolRef gimpleSymbolRef : statement.findVariableUses()) {
                    if (!this.localVariables.containsKey(gimpleSymbolRef.getId()) || initialized.contains(gimpleSymbolRef.getId())) continue;
                    result.add(this.localVariables.get(gimpleSymbolRef.getId()));
                }
                this.updateInitializedSet(statement, initialized);
            }
        }
        return result;
    }

    private Set<Integer> applyJoin(ControlFlowGraph.Node node) {
        Iterator<ControlFlowGraph.Node> incomingIt = node.getIncoming().iterator();
        Sets.SetView state = new HashSet((Collection)this.exitState.get(incomingIt.next()));
        while (incomingIt.hasNext()) {
            state = Sets.intersection(state, this.exitState.get(incomingIt.next()));
        }
        return state;
    }

    private Set<Integer> applyTransfer(Set<Integer> initialState, GimpleBasicBlock basicBlock) {
        HashSet<Integer> exitState = new HashSet<Integer>(initialState);
        if (basicBlock != null) {
            for (GimpleStatement ins : basicBlock.getStatements()) {
                this.updateInitializedSet(ins, exitState);
            }
        }
        return exitState;
    }

    private void updateInitializedSet(GimpleStatement statement, Set<Integer> initializedVariables) {
        Optional<GimpleVariableRef> variableRef = Optional.absent();
        if (statement instanceof GimpleAssignment) {
            variableRef = this.findVariableRef(((GimpleAssignment)statement).getLHS());
        } else if (statement instanceof GimpleCall) {
            variableRef = this.findVariableRef(((GimpleCall)statement).getLhs());
        }
        if (variableRef.isPresent()) {
            initializedVariables.add(((GimpleVariableRef)variableRef.get()).getId());
        }
    }

    private Optional<GimpleVariableRef> findVariableRef(GimpleExpr lhs) {
        if (lhs instanceof GimpleVariableRef) {
            GimpleVariableRef ref = (GimpleVariableRef)lhs;
            if (this.localVariables.containsKey(ref.getId())) {
                return Optional.of((Object)ref);
            }
            return Optional.absent();
        }
        if (lhs instanceof GimpleMemRef) {
            return this.findVariableRef(((GimpleMemRef)lhs).getPointer());
        }
        if (lhs instanceof GimpleAddressOf) {
            return this.findVariableRef(((GimpleAddressOf)lhs).getValue());
        }
        if (lhs instanceof GimpleComponentRef) {
            return this.findVariableRef(((GimpleComponentRef)lhs).getValue());
        }
        return Optional.absent();
    }

    public void dump() {
        for (ControlFlowGraph.Node node : this.cfg.getBasicBlockNodes()) {
            System.out.println(node.getId() + ": " + this.toString(this.entryState.get(node)) + " -> " + this.toString(this.exitState.get(node)));
        }
    }

    private String toString(Set<Integer> variableIds) {
        StringBuilder sb = new StringBuilder("[");
        boolean needsComma = false;
        for (Integer variableId : variableIds) {
            if (needsComma) {
                sb.append(", ");
            }
            sb.append(this.localVariables.get(variableId).getName());
            needsComma = true;
        }
        sb.append("]");
        return sb.toString();
    }
}

