/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.base.Predicate;
import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.analysis.CallGraph;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleOp;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleAddressOf;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleLValue;
import org.renjin.gcc.gimple.expr.GimpleMemRef;
import org.renjin.gcc.gimple.expr.GimpleParamRef;
import org.renjin.gcc.gimple.statement.GimpleAssignment;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.type.GimpleIndirectType;
import org.renjin.gcc.gimple.type.GimplePrimitiveType;
import org.renjin.gcc.gimple.type.GimpleType;

public class Depointerizer {
    private CallGraph callGraph;
    private Queue<CallGraph.FunctionNode> workList = Lists.newLinkedList();

    public Depointerizer(CallGraph callGraph) {
        this.callGraph = callGraph;
    }

    public void run() {
        this.workList.addAll(this.callGraph.getFunctionNodes());
        while (!this.workList.isEmpty()) {
            this.transform(this.workList.poll());
        }
    }

    public boolean transform(CallGraph.FunctionNode functionNode) {
        GimpleFunction fn = functionNode.getFunction();
        HashSet blacklist = Sets.newHashSet();
        for (GimpleBasicBlock basicBlock : fn.getBasicBlocks()) {
            for (GimpleStatement statement : basicBlock.getStatements()) {
                for (GimpleExpr operand : statement.getOperands()) {
                    this.checkUse(blacklist, operand);
                }
                if (statement instanceof GimpleAssignment) {
                    this.checkLhs(blacklist, ((GimpleAssignment)statement).getLHS());
                    continue;
                }
                if (!(statement instanceof GimpleCall)) continue;
                this.checkLhs(blacklist, ((GimpleCall)statement).getLhs());
            }
        }
        for (GimpleParameter parameter : fn.getParameters()) {
            if (!this.isPrimitivePointer(parameter) || blacklist.contains(parameter.getId())) continue;
            this.depointerize(functionNode, parameter);
        }
        return false;
    }

    private void checkLhs(Set<Integer> blacklist, GimpleLValue lhs) {
        this.checkUse(blacklist, lhs);
        if (lhs instanceof GimpleMemRef) {
            this.checkUse(blacklist, ((GimpleMemRef)lhs).getPointer());
        }
    }

    private void depointerize(CallGraph.FunctionNode fn, GimpleParameter parameter) {
        System.out.println("Depointerizing " + parameter.getName() + " in " + fn.getFunction().getName());
        parameter.setType((GimpleType)parameter.getType().getBaseType());
        IsParameterMemRef predicate = new IsParameterMemRef(parameter);
        for (GimpleBasicBlock basicBlock : fn.getFunction().getBasicBlocks()) {
            for (GimpleStatement statement : basicBlock.getStatements()) {
                if (statement instanceof GimpleAssignment) {
                    GimpleAssignment assignment = (GimpleAssignment)statement;
                    if (!assignment.replace(predicate, new GimpleParamRef(parameter))) continue;
                    assignment.setOperator(GimpleOp.NOP_EXPR);
                    continue;
                }
                statement.replaceAll(predicate, new GimpleParamRef(parameter));
            }
        }
        int parameterIndex = fn.getFunction().getParameters().indexOf(parameter);
        for (CallGraph.CallSite callSite : fn.getCallSites()) {
            this.dereferenceArgument(callSite, parameter, parameterIndex);
        }
    }

    private void dereferenceArgument(CallGraph.CallSite callSite, GimpleParameter parameter, int parameterIndex) {
        List<GimpleExpr> arguments = callSite.getStatement().getOperands();
        GimpleExpr argumentExpr = arguments.get(parameterIndex);
        if (!(argumentExpr.getType() instanceof GimpleIndirectType)) {
            throw new InternalCompilerException("Exception de-pointerizing parameter " + parameter.getName() + " in call site " + callSite.getStatement() + ": unexpected parameter type " + argumentExpr.getType());
        }
        GimpleFunction callingFunction = callSite.getCallingFunction().getFunction();
        GimpleVarDecl tempVariable = callingFunction.addVarDecl(parameter.getType());
        GimpleAssignment assignment = new GimpleAssignment(GimpleOp.MEM_REF, tempVariable.newRef(), this.dereference(argumentExpr));
        callSite.insertBefore(assignment);
        callSite.getStatement().getOperands().set(parameterIndex, tempVariable.newRef());
        if (!this.workList.contains(callSite.getCallingFunction())) {
            this.workList.add(callSite.getCallingFunction());
        }
    }

    private GimpleExpr dereference(GimpleExpr argumentExpr) {
        if (argumentExpr instanceof GimpleAddressOf) {
            return ((GimpleAddressOf)argumentExpr).getValue();
        }
        return new GimpleMemRef(argumentExpr);
    }

    private boolean isPrimitivePointer(GimpleParameter parameter) {
        return parameter.getType() instanceof GimpleIndirectType && parameter.getType().getBaseType() instanceof GimplePrimitiveType;
    }

    private void checkUse(Set<Integer> blacklist, GimpleExpr expr) {
        GimpleMemRef memRef;
        if (expr instanceof GimpleParamRef) {
            blacklist.add(((GimpleParamRef)expr).getId());
        }
        if (expr instanceof GimpleMemRef && !(memRef = (GimpleMemRef)expr).isOffsetZero()) {
            this.checkUse(blacklist, ((GimpleMemRef)expr).getPointer());
        }
    }

    private static class IsParameterMemRef
    implements Predicate<GimpleExpr> {
        private final GimpleParameter parameter;

        public IsParameterMemRef(GimpleParameter parameter) {
            this.parameter = parameter;
        }

        public boolean apply(GimpleExpr input) {
            GimpleParamRef ref;
            GimpleExpr pointer;
            return input instanceof GimpleMemRef && (pointer = ((GimpleMemRef)input).getPointer()) instanceof GimpleParamRef && (ref = (GimpleParamRef)pointer).getId() == this.parameter.getId();
        }
    }
}

