/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.collect.Iterators;
import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Maps;
import com.google.bc.common.collect.PeekingIterator;
import com.google.bc.common.escape.Escaper;
import com.google.bc.common.escape.Escapers;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.statement.GimpleEdge;

public class ControlFlowGraph {
    private Node entryNode = new Node("Entry");
    private Node exitNode = new Node("Exit");
    private Map<Integer, Node> nodes = Maps.newHashMap();

    public ControlFlowGraph(GimpleFunction function) {
        for (GimpleBasicBlock basicBlock : function.getBasicBlocks()) {
            this.nodes.put(basicBlock.getIndex(), new Node(basicBlock));
        }
        this.addEdge(this.entryNode, this.getNode(function.getBasicBlocks().get(0)));
        PeekingIterator it = Iterators.peekingIterator(function.getBasicBlocks().iterator());
        while (it.hasNext()) {
            GimpleBasicBlock sourceBlock = (GimpleBasicBlock)it.next();
            Node sourceNode = this.nodes.get(sourceBlock.getIndex());
            List<GimpleEdge> jumps = sourceBlock.getJumps();
            if (jumps.isEmpty()) {
                if (!it.hasNext()) continue;
                this.addEdge(sourceNode, this.getNode((GimpleBasicBlock)it.peek()));
                continue;
            }
            for (GimpleEdge jump : jumps) {
                sourceNode = this.nodes.get(jump.getSource());
                Node targetNode = jump.getTarget() == 1 ? this.exitNode : this.nodes.get(jump.getTarget());
                this.addEdge(sourceNode, targetNode);
            }
        }
    }

    public Iterable<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(this.entryNode);
        nodes.add(this.exitNode);
        nodes.addAll(this.nodes.values());
        return nodes;
    }

    public Node getNode(GimpleBasicBlock bb) {
        return this.nodes.get(bb.getIndex());
    }

    private void addEdge(Node from, Node to) {
        from.outgoing.add(to);
        to.incoming.add(from);
    }

    public void dumpGraph(File file) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            this.dumpGraph(writer);
        }
    }

    public Collection<Node> getBasicBlockNodes() {
        return this.nodes.values();
    }

    public void dumpGraph(PrintWriter writer) {
        Escaper escaper = Escapers.builder().addEscape('\"', "\\\"").addEscape('\n', "\\n").build();
        writer.println("digraph {");
        writer.println(String.format("%s[label=\"Entry\"]", this.entryNode.id));
        writer.println(String.format("%s[label=\"Exit\"]", this.exitNode.id));
        for (Node node : this.nodes.values()) {
            writer.println(String.format("%s[label=\"%s\", shape=\"rect\"]", node.id, escaper.escape(node.basicBlock.toString())));
        }
        for (Node node : this.getNodes()) {
            for (Node out : node.outgoing) {
                writer.println(node.id + " -> " + out.id);
            }
        }
        writer.println("}");
    }

    public class Node {
        private String id;
        private GimpleBasicBlock basicBlock;
        private List<Node> incoming = Lists.newArrayList();
        private List<Node> outgoing = Lists.newArrayList();

        public Node(String id) {
            this.id = id;
        }

        public Node(GimpleBasicBlock basicBlock) {
            this.basicBlock = basicBlock;
            this.id = "BB" + basicBlock.getIndex();
        }

        public String getId() {
            return this.id;
        }

        public GimpleBasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public List<Node> getIncoming() {
            return this.incoming;
        }

        public List<Node> getOutgoing() {
            return this.outgoing;
        }

        public String toString() {
            return "<" + this.id + ">";
        }
    }
}

