/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.expr.GimpleAddressOf;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleFunctionRef;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleStatement;

public class CallGraph {
    private List<FunctionNode> functionNodes = Lists.newArrayList();
    private List<CallSite> callSites = Lists.newArrayList();

    public CallGraph(Collection<GimpleCompilationUnit> units) {
        Map<String, FunctionNode> unitScope;
        HashMap globalScope = Maps.newHashMap();
        HashMap unitScopes = Maps.newHashMap();
        for (GimpleCompilationUnit unit : units) {
            unitScope = Maps.newHashMap();
            for (GimpleFunction function : unit.getFunctions()) {
                FunctionNode node = new FunctionNode(unit, function);
                unitScope.put(function.getName(), node);
                if (function.isExtern()) {
                    globalScope.put(function.getName(), node);
                }
                this.functionNodes.add(node);
            }
            unitScopes.put(unit, unitScope);
        }
        for (FunctionNode callingNode : this.functionNodes) {
            unitScope = (Map)unitScopes.get(callingNode.unit);
            for (GimpleBasicBlock basicBlock : callingNode.getFunction().getBasicBlocks()) {
                for (GimpleStatement statement : basicBlock.getStatements()) {
                    if (!(statement instanceof GimpleCall)) continue;
                    CallSite callSite = new CallSite(callingNode, basicBlock, (GimpleCall)statement);
                    FunctionNode functionNode = this.findFunction((GimpleCall)statement, unitScope, globalScope);
                    if (functionNode != null) {
                        functionNode.callSites.add(callSite);
                    }
                    this.callSites.add(callSite);
                }
            }
        }
    }

    public List<FunctionNode> getFunctionNodes() {
        return this.functionNodes;
    }

    public List<CallSite> getCallSites() {
        return this.callSites;
    }

    private FunctionNode findFunction(GimpleCall statement, Map<String, FunctionNode> unitScope, Map<String, FunctionNode> globalScope) {
        GimpleAddressOf functionPtr;
        GimpleExpr functionExpr = statement.getFunction();
        if (functionExpr instanceof GimpleAddressOf && (functionPtr = (GimpleAddressOf)functionExpr).getValue() instanceof GimpleFunctionRef) {
            GimpleFunctionRef ref = (GimpleFunctionRef)functionPtr.getValue();
            FunctionNode node = unitScope.get(ref.getName());
            if (node == null) {
                return globalScope.get(ref.getName());
            }
            return node;
        }
        return null;
    }

    public class CallSite {
        private final FunctionNode callingFunction;
        private final GimpleBasicBlock basicBlock;
        private final GimpleCall statement;

        public CallSite(FunctionNode callingFunction, GimpleBasicBlock basicBlock, GimpleCall statement) {
            this.callingFunction = callingFunction;
            this.basicBlock = basicBlock;
            this.statement = statement;
        }

        public GimpleCall getStatement() {
            return this.statement;
        }

        public FunctionNode getCallingFunction() {
            return this.callingFunction;
        }

        public void insertBefore(GimpleStatement newStatement) {
            int callIndex = this.basicBlock.getStatements().indexOf(this.statement);
            this.basicBlock.getStatements().add(callIndex, newStatement);
        }
    }

    public class FunctionNode {
        private final GimpleCompilationUnit unit;
        private final GimpleFunction function;
        private final List<CallSite> callSites = Lists.newArrayList();

        public FunctionNode(GimpleCompilationUnit unit, GimpleFunction function) {
            this.unit = unit;
            this.function = function;
        }

        public GimpleFunction getFunction() {
            return this.function;
        }

        public List<CallSite> getCallSites() {
            return this.callSites;
        }
    }
}

