/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.analysis;

import com.google.bc.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.renjin.gcc.analysis.FunctionBodyTransformer;
import org.renjin.gcc.gimple.GimpleBasicBlock;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.GimpleParameter;
import org.renjin.gcc.gimple.GimpleVarDecl;
import org.renjin.gcc.gimple.expr.GimpleAddressOf;
import org.renjin.gcc.gimple.expr.GimpleComponentRef;
import org.renjin.gcc.gimple.expr.GimpleExpr;
import org.renjin.gcc.gimple.expr.GimpleFieldRef;
import org.renjin.gcc.gimple.expr.GimpleSymbolRef;
import org.renjin.gcc.gimple.statement.GimpleAssignment;
import org.renjin.gcc.gimple.statement.GimpleCall;
import org.renjin.gcc.gimple.statement.GimpleStatement;
import org.renjin.gcc.gimple.type.GimpleArrayType;
import org.renjin.gcc.gimple.type.GimpleField;
import org.renjin.gcc.gimple.type.GimpleRecordType;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;

public class AddressableFinder
implements FunctionBodyTransformer {
    public static final AddressableFinder INSTANCE = new AddressableFinder();

    @Override
    public boolean transform(GimpleCompilationUnit unit, GimpleFunction fn) {
        boolean updated = false;
        Marker marker = new Marker(unit, fn);
        for (GimpleBasicBlock basicBlock : fn.getBasicBlocks()) {
            for (GimpleStatement gimpleIns : basicBlock.getStatements()) {
                if (gimpleIns instanceof GimpleCall) {
                    if (!marker.mark(gimpleIns.getOperands())) continue;
                    updated = true;
                    continue;
                }
                if (!(gimpleIns instanceof GimpleAssignment) || !marker.mark(gimpleIns.getOperands())) continue;
                updated = true;
            }
        }
        return updated;
    }

    private class Marker {
        private final Map<Integer, GimpleVarDecl> variables = Maps.newHashMap();
        private final Map<Integer, GimpleParameter> parameters = Maps.newHashMap();
        private final Map<String, GimpleRecordTypeDef> recordTypeDefs = Maps.newHashMap();

        public Marker(GimpleCompilationUnit unit, GimpleFunction fn) {
            for (GimpleParameter param : fn.getParameters()) {
                this.parameters.put(param.getId(), param);
            }
            for (GimpleVarDecl varDecl : fn.getVariableDeclarations()) {
                this.variables.put(varDecl.getId(), varDecl);
            }
            for (GimpleVarDecl unitGlobalVar : unit.getGlobalVariables()) {
                this.variables.put(unitGlobalVar.getId(), unitGlobalVar);
            }
            for (GimpleRecordTypeDef unitRecordType : unit.getRecordTypes()) {
                this.recordTypeDefs.put(unitRecordType.getId(), unitRecordType);
            }
        }

        public boolean mark(List<GimpleExpr> arguments) {
            boolean updated = false;
            for (GimpleExpr expr : arguments) {
                GimpleParameter param;
                GimpleVarDecl decl;
                Object ref;
                if (!(expr instanceof GimpleAddressOf)) continue;
                GimpleAddressOf addressOf = (GimpleAddressOf)expr;
                if (addressOf.getValue() instanceof GimpleComponentRef) {
                    ref = (GimpleComponentRef)addressOf.getValue();
                    GimpleRecordType recordType = (GimpleRecordType)((GimpleComponentRef)ref).getValue().getType();
                    GimpleRecordTypeDef recordTypeDef = this.recordTypeDefs.get(recordType.getId());
                    if (recordTypeDef == null) {
                        throw new IllegalStateException("Record def not found: " + recordType);
                    }
                    if (this.markField(recordTypeDef, ((GimpleComponentRef)ref).getMember())) {
                        updated = true;
                    }
                }
                if (!(addressOf.getValue() instanceof GimpleSymbolRef)) continue;
                ref = (GimpleSymbolRef)((Object)addressOf.getValue());
                if (this.variables.containsKey(ref.getId()) && !(decl = this.variables.get(ref.getId())).isAddressable()) {
                    decl.setAddressable(true);
                    updated = true;
                }
                if (!this.parameters.containsKey(ref.getId()) || (param = this.parameters.get(ref.getId())).isAddressable()) continue;
                param.setAddressable(true);
                updated = true;
            }
            return updated;
        }

        private boolean markField(GimpleRecordTypeDef recordTypeDef, GimpleFieldRef member) {
            GimpleField field = recordTypeDef.findField(member);
            if (field.getOffset() == member.getOffset() && field.getType().equals(member.getType())) {
                boolean wasMarked = field.isAddressed();
                field.setAddressed(true);
                return !wasMarked;
            }
            if (field.getType() instanceof GimpleArrayType) {
                return false;
            }
            throw new IllegalStateException("Cannot match field " + member + " to record def " + recordTypeDef);
        }
    }
}

