/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc;

import java.io.File;

public final class PlatformUtils {
    public static final ARCHType ARCH = PlatformUtils.calculateArch();
    public static final OSType OS = PlatformUtils.calculateOS();

    public static String getPortableLibraryName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() == 0 || name.contains(File.separator) || name.contains("/")) {
            throw new IllegalArgumentException("Directory separator should not appear in library name: " + name);
        }
        return name.toLowerCase() + PlatformUtils.getSuffix() + PlatformUtils.getExtension();
    }

    public static String getExtension() {
        switch (OS) {
            case APPLE: {
                return ".so";
            }
            case WINDOWS: {
                return ".dll";
            }
        }
        return ".so";
    }

    public static void main(String[] args) {
        System.out.println((Object)((Object)OS) + ", " + (Object)((Object)ARCH) + ", " + PlatformUtils.getPortableLibraryName("NAME"));
    }

    private static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch").toLowerCase();
        assert (osArch != null);
        if (osArch.equals("i386")) {
            return ARCHType.X86;
        }
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (osArch.equals("ppc")) {
            return ARCHType.PPC;
        }
        if (osArch.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (osArch.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        return ARCHType.UNKNOWN;
    }

    private static OSType calculateOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        assert (osName != null);
        if (osName.startsWith("mac os x")) {
            return OSType.APPLE;
        }
        if (osName.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osName.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }

    private static String getSuffix() {
        String prefix = "-" + OS.toString().toLowerCase() + "-" + ARCH.toString().toLowerCase();
        return prefix;
    }

    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        UNKNOWN,
        WINDOWS;

    }

    public static enum ARCHType {
        PPC,
        PPC_64,
        SPARC,
        UNKNOWN,
        X86,
        X86_64;

    }
}

