/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc;

import com.google.bc.common.annotations.VisibleForTesting;
import com.google.bc.common.base.Preconditions;
import com.google.bc.common.collect.Lists;
import com.google.bc.common.collect.Maps;
import com.google.bc.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.renjin.gcc.InternalCompilerException;
import org.renjin.gcc.analysis.AddressableFinder;
import org.renjin.gcc.analysis.FunctionBodyTransformer;
import org.renjin.gcc.analysis.LocalVariableInitializer;
import org.renjin.gcc.analysis.RecordTypeDefCanonicalizer;
import org.renjin.gcc.analysis.RecordUsageAnalyzer;
import org.renjin.gcc.analysis.ResultDeclRewriter;
import org.renjin.gcc.analysis.VoidPointerTypeDeducer;
import org.renjin.gcc.codegen.FunctionGenerator;
import org.renjin.gcc.codegen.TrampolineClassGenerator;
import org.renjin.gcc.codegen.UnitClassGenerator;
import org.renjin.gcc.codegen.call.CallGenerator;
import org.renjin.gcc.codegen.call.FunctionCallGenerator;
import org.renjin.gcc.codegen.lib.SymbolLibrary;
import org.renjin.gcc.codegen.type.TypeOracle;
import org.renjin.gcc.codegen.type.record.RecordClassTypeStrategy;
import org.renjin.gcc.codegen.type.record.RecordTypeStrategy;
import org.renjin.gcc.gimple.GimpleCompilationUnit;
import org.renjin.gcc.gimple.GimpleFunction;
import org.renjin.gcc.gimple.type.GimpleRecordTypeDef;
import org.renjin.gcc.symbols.GlobalSymbolTable;

public class GimpleCompiler {
    public static boolean TRACE = false;
    private File outputDirectory;
    private String packageName;
    private boolean verbose;
    private GlobalSymbolTable globalSymbolTable;
    private Collection<GimpleRecordTypeDef> recordTypeDefs;
    private RecordUsageAnalyzer recordUsage;
    private List<FunctionBodyTransformer> functionBodyTransformers = Lists.newArrayList();
    private final TypeOracle typeOracle = new TypeOracle();
    private final Map<String, Class> providedRecordTypes = Maps.newHashMap();
    private final Map<String, Field> providedVariables = Maps.newHashMap();
    private String trampolineClassName;
    private String recordClassPrefix = "record";

    public GimpleCompiler() {
        this.functionBodyTransformers.add(VoidPointerTypeDeducer.INSTANCE);
        this.functionBodyTransformers.add(AddressableFinder.INSTANCE);
        this.functionBodyTransformers.add(ResultDeclRewriter.INSTANCE);
        this.functionBodyTransformers.add(LocalVariableInitializer.INSTANCE);
        this.globalSymbolTable = new GlobalSymbolTable(this.typeOracle);
        this.globalSymbolTable.addDefaults();
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public void setOutputDirectory(File directory) {
        this.outputDirectory = directory;
    }

    public void setClassName(String className) {
        this.trampolineClassName = className;
    }

    public void addReferenceClass(Class<?> clazz) {
        this.globalSymbolTable.addMethods(clazz);
        for (Field field : clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            this.addVariable(field.getName(), field);
        }
    }

    public void addMathLibrary() {
        this.globalSymbolTable.addMethod("log", Math.class);
        this.globalSymbolTable.addMethod("exp", Math.class);
    }

    public void addLibrary(SymbolLibrary lib) {
        this.globalSymbolTable.addLibrary(lib);
    }

    public void addMethod(String functionName, Class declaringClass, String methodName) {
        this.globalSymbolTable.addMethod(functionName, declaringClass, methodName);
    }

    public void addRecordClass(String typeName, Class recordClass) {
        this.providedRecordTypes.put(typeName, recordClass);
    }

    public void compile(List<GimpleCompilationUnit> units) throws Exception {
        this.recordTypeDefs = RecordTypeDefCanonicalizer.canonicalize(units);
        this.transform(units);
        this.recordUsage = new RecordUsageAnalyzer(this.recordTypeDefs);
        this.recordUsage.analyze(units);
        this.compileRecords(units);
        ArrayList unitClassGenerators = Lists.newArrayList();
        for (GimpleCompilationUnit unit : units) {
            String className = this.classNameForUnit(unit.getName());
            UnitClassGenerator generator = new UnitClassGenerator(this.typeOracle, this.globalSymbolTable, this.providedVariables, unit, className);
            unitClassGenerators.add(generator);
        }
        for (UnitClassGenerator generator : unitClassGenerators) {
            generator.emit();
            this.writeClass(generator.getClassName(), generator.toByteArray());
        }
        if (this.trampolineClassName != null) {
            this.writeTrampolineClass();
        }
    }

    private void compileRecords(List<GimpleCompilationUnit> units) throws IOException {
        int recordIndex = 0;
        for (GimpleRecordTypeDef recordTypeDef : this.recordTypeDefs) {
            RecordClassTypeStrategy strategy = this.recordUsage.getStrategyFor(recordTypeDef);
            if (this.isProvided(recordTypeDef)) {
                strategy.setProvided(true);
                strategy.setJvmType(Type.getType((Class)this.providedRecordTypes.get(recordTypeDef.getName())));
            } else {
                strategy.setProvided(false);
                String recordClassName = recordTypeDef.getName() != null ? String.format("%s$%s", this.recordClassPrefix, recordTypeDef.getName()) : String.format("%s$Record%d", this.recordClassPrefix, recordIndex++);
                strategy.setJvmType(Type.getType((String)("L" + this.getInternalClassName(recordClassName) + ";")));
            }
            this.typeOracle.addRecordType(recordTypeDef, strategy);
        }
        for (RecordTypeStrategy recordTypeStrategy : this.typeOracle.getRecordTypes()) {
            try {
                recordTypeStrategy.linkFields(this.typeOracle);
            }
            catch (Exception e) {
                throw new InternalCompilerException(String.format("Exception linking record %s: %s", recordTypeStrategy.getRecordTypeDef().getName(), e.getMessage()), (Throwable)e);
            }
        }
        for (RecordTypeStrategy recordTypeStrategy : this.typeOracle.getRecordTypes()) {
            recordTypeStrategy.writeClassFiles(this.outputDirectory);
        }
    }

    private boolean isProvided(GimpleRecordTypeDef recordTypeDef) {
        if (recordTypeDef.getName() == null) {
            return false;
        }
        return this.providedRecordTypes.containsKey(recordTypeDef.getName());
    }

    private String classNameForUnit(String className) {
        if (this.trampolineClassName != null) {
            return this.getInternalClassName(className) + "__";
        }
        return this.getInternalClassName(className);
    }

    private String getInternalClassName(String className) {
        return (this.packageName + "." + GimpleCompiler.sanitize(className)).replace('.', '/');
    }

    @VisibleForTesting
    static String sanitize(String name) {
        Preconditions.checkArgument((name.length() >= 1 ? 1 : 0) != 0);
        StringBuilder className = new StringBuilder();
        int i = 0;
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            className.append(name.charAt(0));
            ++i;
        } else {
            className.append('_');
        }
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                className.append(c);
            } else {
                className.append("_");
            }
            ++i;
        }
        return className.toString();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void transform(List<GimpleCompilationUnit> units) {
        for (GimpleCompilationUnit unit : units) {
            if (TRACE) {
                System.out.println(unit);
            }
            for (GimpleFunction function : unit.getFunctions()) {
                this.transformFunctionBody(unit, function);
            }
        }
    }

    private void transformFunctionBody(GimpleCompilationUnit unit, GimpleFunction function) {
        boolean updated;
        do {
            updated = false;
            for (FunctionBodyTransformer transformer : this.functionBodyTransformers) {
                if (!transformer.transform(unit, function)) continue;
                updated = true;
            }
        } while (updated);
    }

    private void writeTrampolineClass() throws IOException {
        TrampolineClassGenerator classGenerator = new TrampolineClassGenerator(this.getInternalClassName(this.trampolineClassName));
        for (Map.Entry<String, CallGenerator> entry : this.globalSymbolTable.getFunctions()) {
            FunctionCallGenerator functionCallGenerator;
            if (!(entry.getValue() instanceof FunctionCallGenerator) || !((functionCallGenerator = (FunctionCallGenerator)entry.getValue()).getStrategy() instanceof FunctionGenerator)) continue;
            FunctionGenerator functionGenerator = (FunctionGenerator)functionCallGenerator.getStrategy();
            classGenerator.emitTrampolineMethod(functionGenerator);
        }
        this.writeClass(this.getInternalClassName(this.trampolineClassName), classGenerator.generateClassFile());
    }

    private void writeClass(String internalName, byte[] classByteArray) throws IOException {
        boolean created;
        File classFile = new File(this.outputDirectory.getAbsolutePath() + File.separator + internalName + ".class");
        if (!classFile.getParentFile().exists() && !(created = classFile.getParentFile().mkdirs())) {
            throw new IOException("Failed to create directory for class file: " + classFile.getParentFile());
        }
        Files.write((byte[])classByteArray, (File)classFile);
    }

    public void addVariable(String globalVariableName, Class<?> declaringClass) {
        try {
            this.addVariable(globalVariableName, declaringClass.getField(globalVariableName));
        }
        catch (NoSuchFieldException e) {
            throw new InternalCompilerException("Cannot find field", (Throwable)e);
        }
    }

    public void addVariable(String name, Field field) {
        this.providedVariables.put(name, field);
    }

    public String getRecordClassPrefix() {
        return this.recordClassPrefix;
    }

    public void setRecordClassPrefix(String recordClassPrefix) {
        this.recordClassPrefix = recordClassPrefix;
    }
}

